/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.model.documenteditor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.onlyoffice.model.documenteditor.history.Version;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class History {
    private String currentVersion;
    private List<Version> history;

    History(String currentVersion, List<Version> history) {
        this.currentVersion = currentVersion;
        this.history = history;
    }

    public static HistoryBuilder builder() {
        return new HistoryBuilder();
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public List<Version> getHistory() {
        return this.history;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void setHistory(List<Version> history) {
        this.history = history;
    }

    public static class HistoryBuilder {
        private String currentVersion;
        private List<Version> history;

        HistoryBuilder() {
        }

        public HistoryBuilder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public HistoryBuilder history(List<Version> history) {
            this.history = history;
            return this;
        }

        public History build() {
            return new History(this.currentVersion, this.history);
        }

        public String toString() {
            return "History.HistoryBuilder(currentVersion=" + this.currentVersion + ", history=" + this.history + ")";
        }
    }
}

