/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.rp;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.client.RegistrationError;
import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.id.SectorID;
import com.nimbusds.openid.connect.sdk.rp.ApplicationType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class OIDCClientMetadata
extends ClientMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private ApplicationType applicationType;
    private SubjectType subjectType;
    private URI sectorIDURI;
    private Set<URI> requestObjectURIs;
    private JWSAlgorithm requestObjectJWSAlg;
    private JWEAlgorithm requestObjectJWEAlg;
    private EncryptionMethod requestObjectJWEEnc;
    private JWSAlgorithm idTokenJWSAlg;
    private JWEAlgorithm idTokenJWEAlg;
    private EncryptionMethod idTokenJWEEnc;
    private JWSAlgorithm userInfoJWSAlg;
    private JWEAlgorithm userInfoJWEAlg;
    private EncryptionMethod userInfoJWEEnc;
    private int defaultMaxAge = -1;
    private boolean requiresAuthTime;
    private List<ACR> defaultACRs;
    private URI initiateLoginURI;
    private Set<URI> postLogoutRedirectURIs;
    private URI frontChannelLogoutURI;
    private boolean frontChannelLogoutSessionRequired = false;
    private URI backChannelLogoutURI;
    private boolean backChannelLogoutSessionRequired = false;

    static {
        HashSet<String> p = new HashSet<String>(ClientMetadata.getRegisteredParameterNames());
        p.add("application_type");
        p.add("subject_type");
        p.add("sector_identifier_uri");
        p.add("request_uris");
        p.add("request_object_signing_alg");
        p.add("request_object_encryption_alg");
        p.add("request_object_encryption_enc");
        p.add("id_token_signed_response_alg");
        p.add("id_token_encrypted_response_alg");
        p.add("id_token_encrypted_response_enc");
        p.add("userinfo_signed_response_alg");
        p.add("userinfo_encrypted_response_alg");
        p.add("userinfo_encrypted_response_enc");
        p.add("default_max_age");
        p.add("require_auth_time");
        p.add("default_acr_values");
        p.add("initiate_login_uri");
        p.add("post_logout_redirect_uris");
        p.add("frontchannel_logout_uri");
        p.add("frontchannel_logout_session_required");
        p.add("backchannel_logout_uri");
        p.add("backchannel_logout_session_required");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }

    public OIDCClientMetadata() {
    }

    public OIDCClientMetadata(ClientMetadata metadata) {
        super(metadata);
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public URI getSectorIDURI() {
        return this.sectorIDURI;
    }

    public void setSectorIDURI(URI sectorIDURI) {
        if (sectorIDURI != null) {
            SectorID.ensureHTTPScheme(sectorIDURI);
            SectorID.ensureHostComponent(sectorIDURI);
        }
        this.sectorIDURI = sectorIDURI;
    }

    public SectorID resolveSectorID() {
        if (!SubjectType.PAIRWISE.equals((Object)this.getSubjectType())) {
            return null;
        }
        if (this.getSectorIDURI() != null) {
            return new SectorID(this.getSectorIDURI());
        }
        if (CollectionUtils.isEmpty(this.getRedirectionURIs())) {
            throw new IllegalStateException("Couldn't resolve sector ID: Missing redirect_uris");
        }
        if (this.getRedirectionURIs().size() > 1) {
            throw new IllegalStateException("Couldn't resolve sector ID: More than one redirect_uri, sector_identifier_uri not specified");
        }
        return new SectorID(this.getRedirectionURIs().iterator().next());
    }

    public Set<URI> getRequestObjectURIs() {
        return this.requestObjectURIs;
    }

    public void setRequestObjectURIs(Set<URI> requestObjectURIs) {
        this.requestObjectURIs = requestObjectURIs;
    }

    public JWSAlgorithm getRequestObjectJWSAlg() {
        return this.requestObjectJWSAlg;
    }

    public void setRequestObjectJWSAlg(JWSAlgorithm requestObjectJWSAlg) {
        this.requestObjectJWSAlg = requestObjectJWSAlg;
    }

    public JWEAlgorithm getRequestObjectJWEAlg() {
        return this.requestObjectJWEAlg;
    }

    public void setRequestObjectJWEAlg(JWEAlgorithm requestObjectJWEAlg) {
        this.requestObjectJWEAlg = requestObjectJWEAlg;
    }

    public EncryptionMethod getRequestObjectJWEEnc() {
        return this.requestObjectJWEEnc;
    }

    public void setRequestObjectJWEEnc(EncryptionMethod requestObjectJWEEnc) {
        this.requestObjectJWEEnc = requestObjectJWEEnc;
    }

    public JWSAlgorithm getIDTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public void setIDTokenJWSAlg(JWSAlgorithm idTokenJWSAlg) {
        this.idTokenJWSAlg = idTokenJWSAlg;
    }

    public JWEAlgorithm getIDTokenJWEAlg() {
        return this.idTokenJWEAlg;
    }

    public void setIDTokenJWEAlg(JWEAlgorithm idTokenJWEAlg) {
        this.idTokenJWEAlg = idTokenJWEAlg;
    }

    public EncryptionMethod getIDTokenJWEEnc() {
        return this.idTokenJWEEnc;
    }

    public void setIDTokenJWEEnc(EncryptionMethod idTokenJWEEnc) {
        this.idTokenJWEEnc = idTokenJWEEnc;
    }

    public JWSAlgorithm getUserInfoJWSAlg() {
        return this.userInfoJWSAlg;
    }

    public void setUserInfoJWSAlg(JWSAlgorithm userInfoJWSAlg) {
        this.userInfoJWSAlg = userInfoJWSAlg;
    }

    public JWEAlgorithm getUserInfoJWEAlg() {
        return this.userInfoJWEAlg;
    }

    public void setUserInfoJWEAlg(JWEAlgorithm userInfoJWEAlg) {
        this.userInfoJWEAlg = userInfoJWEAlg;
    }

    public EncryptionMethod getUserInfoJWEEnc() {
        return this.userInfoJWEEnc;
    }

    public void setUserInfoJWEEnc(EncryptionMethod userInfoJWEEnc) {
        this.userInfoJWEEnc = userInfoJWEEnc;
    }

    public int getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(int defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public boolean requiresAuthTime() {
        return this.requiresAuthTime;
    }

    public void requiresAuthTime(boolean requiresAuthTime) {
        this.requiresAuthTime = requiresAuthTime;
    }

    public List<ACR> getDefaultACRs() {
        return this.defaultACRs;
    }

    public void setDefaultACRs(List<ACR> defaultACRs) {
        this.defaultACRs = defaultACRs;
    }

    public URI getInitiateLoginURI() {
        return this.initiateLoginURI;
    }

    public void setInitiateLoginURI(URI loginURI) {
        this.initiateLoginURI = loginURI;
    }

    public Set<URI> getPostLogoutRedirectionURIs() {
        return this.postLogoutRedirectURIs;
    }

    public void setPostLogoutRedirectionURIs(Set<URI> logoutURIs) {
        this.postLogoutRedirectURIs = logoutURIs;
    }

    public URI getFrontChannelLogoutURI() {
        return this.frontChannelLogoutURI;
    }

    public void setFrontChannelLogoutURI(URI frontChannelLogoutURI) {
        this.frontChannelLogoutURI = frontChannelLogoutURI;
    }

    public boolean requiresFrontChannelLogoutSession() {
        return this.frontChannelLogoutSessionRequired;
    }

    public void requiresFrontChannelLogoutSession(boolean requiresSession) {
        this.frontChannelLogoutSessionRequired = requiresSession;
    }

    public URI getBackChannelLogoutURI() {
        return this.backChannelLogoutURI;
    }

    public void setBackChannelLogoutURI(URI backChannelLogoutURI) {
        this.backChannelLogoutURI = backChannelLogoutURI;
    }

    public boolean requiresBackChannelLogoutSession() {
        return this.backChannelLogoutSessionRequired;
    }

    public void requiresBackChannelLogoutSession(boolean requiresSession) {
        this.backChannelLogoutSessionRequired = requiresSession;
    }

    @Override
    public void applyDefaults() {
        super.applyDefaults();
        if (this.applicationType == null) {
            this.applicationType = ApplicationType.WEB;
        }
        if (this.idTokenJWSAlg == null) {
            this.idTokenJWSAlg = JWSAlgorithm.RS256;
        }
    }

    @Override
    public JSONObject toJSONObject(boolean includeCustomFields) {
        JSONArray uriList;
        JSONObject o = super.toJSONObject(includeCustomFields);
        o.putAll((Map)this.getCustomFields());
        if (this.applicationType != null) {
            o.put((Object)"application_type", (Object)this.applicationType.toString());
        }
        if (this.subjectType != null) {
            o.put((Object)"subject_type", (Object)this.subjectType.toString());
        }
        if (this.sectorIDURI != null) {
            o.put((Object)"sector_identifier_uri", (Object)this.sectorIDURI.toString());
        }
        if (this.requestObjectURIs != null) {
            uriList = new JSONArray();
            for (URI uri : this.requestObjectURIs) {
                uriList.add((Object)uri.toString());
            }
            o.put((Object)"request_uris", (Object)uriList);
        }
        if (this.requestObjectJWSAlg != null) {
            o.put((Object)"request_object_signing_alg", (Object)this.requestObjectJWSAlg.getName());
        }
        if (this.requestObjectJWEAlg != null) {
            o.put((Object)"request_object_encryption_alg", (Object)this.requestObjectJWEAlg.getName());
        }
        if (this.requestObjectJWEEnc != null) {
            o.put((Object)"request_object_encryption_enc", (Object)this.requestObjectJWEEnc.getName());
        }
        if (this.idTokenJWSAlg != null) {
            o.put((Object)"id_token_signed_response_alg", (Object)this.idTokenJWSAlg.getName());
        }
        if (this.idTokenJWEAlg != null) {
            o.put((Object)"id_token_encrypted_response_alg", (Object)this.idTokenJWEAlg.getName());
        }
        if (this.idTokenJWEEnc != null) {
            o.put((Object)"id_token_encrypted_response_enc", (Object)this.idTokenJWEEnc.getName());
        }
        if (this.userInfoJWSAlg != null) {
            o.put((Object)"userinfo_signed_response_alg", (Object)this.userInfoJWSAlg.getName());
        }
        if (this.userInfoJWEAlg != null) {
            o.put((Object)"userinfo_encrypted_response_alg", (Object)this.userInfoJWEAlg.getName());
        }
        if (this.userInfoJWEEnc != null) {
            o.put((Object)"userinfo_encrypted_response_enc", (Object)this.userInfoJWEEnc.getName());
        }
        if (this.defaultMaxAge > 0) {
            o.put((Object)"default_max_age", (Object)this.defaultMaxAge);
        }
        if (this.requiresAuthTime()) {
            o.put((Object)"require_auth_time", (Object)this.requiresAuthTime);
        }
        if (this.defaultACRs != null) {
            JSONArray acrList = new JSONArray();
            for (ACR acr : this.defaultACRs) {
                acrList.add((Object)acr);
            }
            o.put((Object)"default_acr_values", (Object)acrList);
        }
        if (this.initiateLoginURI != null) {
            o.put((Object)"initiate_login_uri", (Object)this.initiateLoginURI.toString());
        }
        if (this.postLogoutRedirectURIs != null) {
            uriList = new JSONArray();
            for (URI uri : this.postLogoutRedirectURIs) {
                uriList.add((Object)uri.toString());
            }
            o.put((Object)"post_logout_redirect_uris", (Object)uriList);
        }
        if (this.frontChannelLogoutURI != null) {
            o.put((Object)"frontchannel_logout_uri", (Object)this.frontChannelLogoutURI.toString());
            o.put((Object)"frontchannel_logout_session_required", (Object)this.frontChannelLogoutSessionRequired);
        }
        if (this.backChannelLogoutURI != null) {
            o.put((Object)"backchannel_logout_uri", (Object)this.backChannelLogoutURI.toString());
            o.put((Object)"backchannel_logout_session_required", (Object)this.backChannelLogoutSessionRequired);
        }
        return o;
    }

    public static OIDCClientMetadata parse(JSONObject jsonObject) throws ParseException {
        ClientMetadata baseMetadata = ClientMetadata.parse(jsonObject);
        OIDCClientMetadata metadata = new OIDCClientMetadata(baseMetadata);
        JSONObject oidcFields = baseMetadata.getCustomFields();
        try {
            String uriString;
            int n;
            int n2;
            String[] stringArray;
            if (jsonObject.get((Object)"application_type") != null) {
                metadata.setApplicationType(JSONObjectUtils.getEnum(jsonObject, "application_type", ApplicationType.class));
                oidcFields.remove((Object)"application_type");
            }
            if (jsonObject.get((Object)"subject_type") != null) {
                metadata.setSubjectType(JSONObjectUtils.getEnum(jsonObject, "subject_type", SubjectType.class));
                oidcFields.remove((Object)"subject_type");
            }
            if (jsonObject.get((Object)"sector_identifier_uri") != null) {
                metadata.setSectorIDURI(JSONObjectUtils.getURI(jsonObject, "sector_identifier_uri"));
                oidcFields.remove((Object)"sector_identifier_uri");
            }
            if (jsonObject.get((Object)"request_uris") != null) {
                LinkedHashSet<URI> requestURIs = new LinkedHashSet<URI>();
                stringArray = JSONObjectUtils.getStringArray(jsonObject, "request_uris");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    uriString = stringArray[n];
                    try {
                        requestURIs.add(new URI(uriString));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new ParseException("Invalid \"request_uris\" parameter");
                    }
                    ++n;
                }
                metadata.setRequestObjectURIs(requestURIs);
                oidcFields.remove((Object)"request_uris");
            }
            if (jsonObject.get((Object)"request_object_signing_alg") != null) {
                metadata.setRequestObjectJWSAlg(JWSAlgorithm.parse((String)JSONObjectUtils.getString(jsonObject, "request_object_signing_alg")));
                oidcFields.remove((Object)"request_object_signing_alg");
            }
            if (jsonObject.get((Object)"request_object_encryption_alg") != null) {
                metadata.setRequestObjectJWEAlg(JWEAlgorithm.parse((String)JSONObjectUtils.getString(jsonObject, "request_object_encryption_alg")));
                oidcFields.remove((Object)"request_object_encryption_alg");
            }
            if (jsonObject.get((Object)"request_object_encryption_enc") != null) {
                metadata.setRequestObjectJWEEnc(EncryptionMethod.parse((String)JSONObjectUtils.getString(jsonObject, "request_object_encryption_enc")));
                oidcFields.remove((Object)"request_object_encryption_enc");
            }
            if (jsonObject.get((Object)"id_token_signed_response_alg") != null) {
                metadata.setIDTokenJWSAlg(JWSAlgorithm.parse((String)JSONObjectUtils.getString(jsonObject, "id_token_signed_response_alg")));
                oidcFields.remove((Object)"id_token_signed_response_alg");
            }
            if (jsonObject.get((Object)"id_token_encrypted_response_alg") != null) {
                metadata.setIDTokenJWEAlg(JWEAlgorithm.parse((String)JSONObjectUtils.getString(jsonObject, "id_token_encrypted_response_alg")));
                oidcFields.remove((Object)"id_token_encrypted_response_alg");
            }
            if (jsonObject.get((Object)"id_token_encrypted_response_enc") != null) {
                metadata.setIDTokenJWEEnc(EncryptionMethod.parse((String)JSONObjectUtils.getString(jsonObject, "id_token_encrypted_response_enc")));
                oidcFields.remove((Object)"id_token_encrypted_response_enc");
            }
            if (jsonObject.get((Object)"userinfo_signed_response_alg") != null) {
                metadata.setUserInfoJWSAlg(JWSAlgorithm.parse((String)JSONObjectUtils.getString(jsonObject, "userinfo_signed_response_alg")));
                oidcFields.remove((Object)"userinfo_signed_response_alg");
            }
            if (jsonObject.get((Object)"userinfo_encrypted_response_alg") != null) {
                metadata.setUserInfoJWEAlg(JWEAlgorithm.parse((String)JSONObjectUtils.getString(jsonObject, "userinfo_encrypted_response_alg")));
                oidcFields.remove((Object)"userinfo_encrypted_response_alg");
            }
            if (jsonObject.get((Object)"userinfo_encrypted_response_enc") != null) {
                metadata.setUserInfoJWEEnc(EncryptionMethod.parse((String)JSONObjectUtils.getString(jsonObject, "userinfo_encrypted_response_enc")));
                oidcFields.remove((Object)"userinfo_encrypted_response_enc");
            }
            if (jsonObject.get((Object)"default_max_age") != null) {
                metadata.setDefaultMaxAge(JSONObjectUtils.getInt(jsonObject, "default_max_age"));
                oidcFields.remove((Object)"default_max_age");
            }
            if (jsonObject.get((Object)"require_auth_time") != null) {
                metadata.requiresAuthTime(JSONObjectUtils.getBoolean(jsonObject, "require_auth_time"));
                oidcFields.remove((Object)"require_auth_time");
            }
            if (jsonObject.get((Object)"default_acr_values") != null) {
                LinkedList<ACR> acrValues = new LinkedList<ACR>();
                stringArray = JSONObjectUtils.getStringArray(jsonObject, "default_acr_values");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String acrString = stringArray[n];
                    acrValues.add(new ACR(acrString));
                    ++n;
                }
                metadata.setDefaultACRs(acrValues);
                oidcFields.remove((Object)"default_acr_values");
            }
            if (jsonObject.get((Object)"initiate_login_uri") != null) {
                metadata.setInitiateLoginURI(JSONObjectUtils.getURI(jsonObject, "initiate_login_uri"));
                oidcFields.remove((Object)"initiate_login_uri");
            }
            if (jsonObject.get((Object)"post_logout_redirect_uris") != null) {
                LinkedHashSet<URI> logoutURIs = new LinkedHashSet<URI>();
                stringArray = JSONObjectUtils.getStringArray(jsonObject, "post_logout_redirect_uris");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    uriString = stringArray[n];
                    try {
                        logoutURIs.add(new URI(uriString));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new ParseException("Invalid \"post_logout_redirect_uris\" parameter");
                    }
                    ++n;
                }
                metadata.setPostLogoutRedirectionURIs(logoutURIs);
                oidcFields.remove((Object)"post_logout_redirect_uris");
            }
            if (jsonObject.get((Object)"frontchannel_logout_uri") != null) {
                metadata.setFrontChannelLogoutURI(JSONObjectUtils.getURI(jsonObject, "frontchannel_logout_uri"));
                if (jsonObject.get((Object)"frontchannel_logout_session_required") != null) {
                    metadata.requiresFrontChannelLogoutSession(JSONObjectUtils.getBoolean(jsonObject, "frontchannel_logout_session_required"));
                }
            }
            if (jsonObject.get((Object)"backchannel_logout_uri") != null) {
                metadata.setBackChannelLogoutURI(JSONObjectUtils.getURI(jsonObject, "backchannel_logout_uri"));
                if (jsonObject.get((Object)"backchannel_logout_session_required") != null) {
                    metadata.requiresBackChannelLogoutSession(JSONObjectUtils.getBoolean(jsonObject, "backchannel_logout_session_required"));
                }
            }
        }
        catch (ParseException e) {
            throw new ParseException(e.getMessage(), RegistrationError.INVALID_CLIENT_METADATA.appendDescription(": " + e.getMessage()), e.getCause());
        }
        metadata.setCustomFields(oidcFields);
        return metadata;
    }

    public static /* bridge */ /* synthetic */ ClientMetadata parse(JSONObject jSONObject) throws ParseException {
        return OIDCClientMetadata.parse(jSONObject);
    }
}

