/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.google.inject.ProvidedBy;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.providers.DefaultEurekaClientConfigProvider;
import com.netflix.governator.guice.lazy.FineGrainedLazySingleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FineGrainedLazySingleton
@ProvidedBy(value=DefaultEurekaClientConfigProvider.class)
public class DefaultEurekaClientConfig
implements EurekaClientConfig {
    private static final String ARCHAIUS_DEPLOYMENT_ENVIRONMENT = "archaius.deployment.environment";
    private static final String TEST = "test";
    private static final String EUREKA_ENVIRONMENT = "eureka.environment";
    private static final Logger logger = LoggerFactory.getLogger(DefaultEurekaClientConfig.class);
    private static final DynamicPropertyFactory configInstance = DynamicPropertyFactory.getInstance();
    private static final DynamicStringProperty EUREKA_PROPS_FILE = DynamicPropertyFactory.getInstance().getStringProperty("eureka.client.props", "eureka-client");
    public static final String DEFAULT_ZONE = "defaultZone";
    private String namespace = "eureka.";

    public DefaultEurekaClientConfig() {
        this.init();
    }

    public DefaultEurekaClientConfig(String namespace) {
        this.namespace = namespace;
        this.init();
    }

    private void init() {
        String env = ConfigurationManager.getConfigInstance().getString(EUREKA_ENVIRONMENT, TEST);
        ConfigurationManager.getConfigInstance().setProperty(ARCHAIUS_DEPLOYMENT_ENVIRONMENT, (Object)env);
        String eurekaPropsFile = EUREKA_PROPS_FILE.get();
        try {
            ConfigurationManager.loadCascadedPropertiesFromResources((String)eurekaPropsFile);
        }
        catch (IOException e) {
            logger.warn("Cannot find the properties specified : {}. This may be okay if there are other environment specific properties or the configuration is installed with a different mechanism.", (Object)eurekaPropsFile);
        }
    }

    @Override
    public int getRegistryFetchIntervalSeconds() {
        return configInstance.getIntProperty(this.namespace + "client.refresh.interval", 30).get();
    }

    @Override
    public int getInstanceInfoReplicationIntervalSeconds() {
        return configInstance.getIntProperty(this.namespace + "appinfo.replicate.interval", 30).get();
    }

    @Override
    public int getInitialInstanceInfoReplicationIntervalSeconds() {
        return configInstance.getIntProperty(this.namespace + "appinfo.initial.replicate.time", 40).get();
    }

    @Override
    public int getEurekaServiceUrlPollIntervalSeconds() {
        return configInstance.getIntProperty(this.namespace + "serviceUrlPollIntervalMs", 300000).get() / 1000;
    }

    @Override
    public String getProxyHost() {
        return configInstance.getStringProperty(this.namespace + "eurekaServer.proxyHost", null).get();
    }

    @Override
    public String getProxyPort() {
        return configInstance.getStringProperty(this.namespace + "eurekaServer.proxyPort", null).get();
    }

    @Override
    public String getProxyUserName() {
        return configInstance.getStringProperty(this.namespace + "eurekaServer.proxyUserName", null).get();
    }

    @Override
    public String getProxyPassword() {
        return configInstance.getStringProperty(this.namespace + "eurekaServer.proxyPassword", null).get();
    }

    @Override
    public boolean shouldGZipContent() {
        return configInstance.getBooleanProperty(this.namespace + "eurekaServer.gzipContent", true).get();
    }

    @Override
    public int getEurekaServerReadTimeoutSeconds() {
        return configInstance.getIntProperty(this.namespace + "eurekaServer.readTimeout", 8).get();
    }

    @Override
    public int getEurekaServerConnectTimeoutSeconds() {
        return configInstance.getIntProperty(this.namespace + "eurekaServer.connectTimeout", 5).get();
    }

    @Override
    public String getBackupRegistryImpl() {
        return configInstance.getStringProperty(this.namespace + "backupregistry", null).get();
    }

    @Override
    public int getEurekaServerTotalConnections() {
        return configInstance.getIntProperty(this.namespace + "eurekaServer.maxTotalConnections", 200).get();
    }

    @Override
    public int getEurekaServerTotalConnectionsPerHost() {
        return configInstance.getIntProperty(this.namespace + "eurekaServer.maxConnectionsPerHost", 50).get();
    }

    @Override
    public String getEurekaServerURLContext() {
        return configInstance.getStringProperty(this.namespace + "eurekaServer.context", configInstance.getStringProperty(this.namespace + "context", null).get()).get();
    }

    @Override
    public String getEurekaServerPort() {
        return configInstance.getStringProperty(this.namespace + "eurekaServer.port", configInstance.getStringProperty(this.namespace + "port", null).get()).get();
    }

    @Override
    public String getEurekaServerDNSName() {
        return configInstance.getStringProperty(this.namespace + "eurekaServer.domainName", configInstance.getStringProperty(this.namespace + "domainName", null).get()).get();
    }

    @Override
    public boolean shouldUseDnsForFetchingServiceUrls() {
        return configInstance.getBooleanProperty(this.namespace + "shouldUseDns", false).get();
    }

    @Override
    public boolean shouldRegisterWithEureka() {
        return configInstance.getBooleanProperty(this.namespace + "registration.enabled", true).get();
    }

    @Override
    public boolean shouldPreferSameZoneEureka() {
        return configInstance.getBooleanProperty(this.namespace + "preferSameZone", true).get();
    }

    @Override
    public boolean allowRedirects() {
        return configInstance.getBooleanProperty(this.namespace + "allowRedirects", false).get();
    }

    @Override
    public boolean shouldLogDeltaDiff() {
        return configInstance.getBooleanProperty(this.namespace + "printDeltaFullDiff", false).get();
    }

    @Override
    public boolean shouldDisableDelta() {
        return configInstance.getBooleanProperty(this.namespace + "disableDelta", false).get();
    }

    @Override
    @Nullable
    public String fetchRegistryForRemoteRegions() {
        return configInstance.getStringProperty(this.namespace + "fetchRemoteRegionsRegistry", null).get();
    }

    @Override
    public String getRegion() {
        return configInstance.getStringProperty("eureka.region", "us-east-1").get();
    }

    @Override
    public String[] getAvailabilityZones(String region) {
        return configInstance.getStringProperty(this.namespace + "" + region + ".availabilityZones", DEFAULT_ZONE).get().split(",");
    }

    @Override
    public List<String> getEurekaServerServiceUrls(String myZone) {
        String serviceUrls = configInstance.getStringProperty(this.namespace + "serviceUrl." + myZone, null).get();
        if (serviceUrls == null || serviceUrls.isEmpty()) {
            serviceUrls = configInstance.getStringProperty(this.namespace + "serviceUrl." + "default", null).get();
        }
        if (serviceUrls != null) {
            return Arrays.asList(serviceUrls.split(","));
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean shouldFilterOnlyUpInstances() {
        return configInstance.getBooleanProperty(this.namespace + "shouldFilterOnlyUpInstances", true).get();
    }

    @Override
    public int getEurekaConnectionIdleTimeoutSeconds() {
        return configInstance.getIntProperty(this.namespace + "eurekaserver.connectionIdleTimeoutInSeconds", 30).get();
    }

    @Override
    public boolean shouldFetchRegistry() {
        return configInstance.getBooleanProperty(this.namespace + "shouldFetchRegistry", true).get();
    }

    @Override
    public String getRegistryRefreshSingleVipAddress() {
        return configInstance.getStringProperty(this.namespace + "registryRefreshSingleVipAddress", null).get();
    }

    @Override
    public int getHeartbeatExecutorThreadPoolSize() {
        return configInstance.getIntProperty(this.namespace + "client.heartbeat.threadPoolSize", 2).get();
    }

    @Override
    public int getHeartbeatExecutorExponentialBackOffBound() {
        return configInstance.getIntProperty(this.namespace + "client.heartbeat.exponentialBackOffBound", 10).get();
    }

    @Override
    public int getCacheRefreshExecutorThreadPoolSize() {
        return configInstance.getIntProperty(this.namespace + "client.cacheRefresh.threadPoolSize", 2).get();
    }

    @Override
    public int getCacheRefreshExecutorExponentialBackOffBound() {
        return configInstance.getIntProperty(this.namespace + "client.cacheRefresh.exponentialBackOffBound", 10).get();
    }

    @Override
    public String getDollarReplacement() {
        return configInstance.getStringProperty(this.namespace + "dollarReplacement", "_-").get();
    }

    @Override
    public String getEscapeCharReplacement() {
        return configInstance.getStringProperty(this.namespace + "escapeCharReplacement", "__").get();
    }
}

