/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.signal;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.signal.ISignalV2Service;
import com.netease.nim.server.sdk.im.v2.signal.request.CancelSignalRoomInviteRequestV2;
import com.netease.nim.server.sdk.im.v2.signal.request.CloseSignalRoomRequestV2;
import com.netease.nim.server.sdk.im.v2.signal.request.CreateSignalRoomRequestV2;
import com.netease.nim.server.sdk.im.v2.signal.request.DelaySignalRoomRequestV2;
import com.netease.nim.server.sdk.im.v2.signal.request.InviteSignalRoomRequestV2;
import com.netease.nim.server.sdk.im.v2.signal.request.KickSignalRoomMemberRequestV2;
import com.netease.nim.server.sdk.im.v2.signal.request.QuerySignalRoomRequestV2;
import com.netease.nim.server.sdk.im.v2.signal.request.SendSignalRoomControlRequestV2;
import com.netease.nim.server.sdk.im.v2.signal.response.CancelSignalRoomInviteResponseV2;
import com.netease.nim.server.sdk.im.v2.signal.response.CloseSignalRoomResponseV2;
import com.netease.nim.server.sdk.im.v2.signal.response.CreateSIgnalRoomResponseV2;
import com.netease.nim.server.sdk.im.v2.signal.response.DelaySignalRoomResponseV2;
import com.netease.nim.server.sdk.im.v2.signal.response.InviteSignalRoomResponseV2;
import com.netease.nim.server.sdk.im.v2.signal.response.KickSignalRoomMemberResponseV2;
import com.netease.nim.server.sdk.im.v2.signal.response.QuerySignalRoomResponseV2;
import com.netease.nim.server.sdk.im.v2.signal.response.SendSignalRoomControlResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;

public class SignalV2Service
implements ISignalV2Service {
    private final YunxinApiHttpClient httpClient;

    public SignalV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<CreateSIgnalRoomResponseV2> createRoom(CreateSignalRoomRequestV2 request) throws YunxinSdkException {
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/signalling_room", "/im/v2/signalling_room", null, requestBody);
        return ResultUtils.convert(apiResponse, CreateSIgnalRoomResponseV2.class);
    }

    @Override
    public Result<DelaySignalRoomResponseV2> delayRoom(DelaySignalRoomRequestV2 request) throws YunxinSdkException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("channel_id", request.getChannelId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PUT, "/im/v2/signalling_room", "/im/v2/signalling_room", queryParams, null);
        return ResultUtils.convert(apiResponse, DelaySignalRoomResponseV2.class);
    }

    @Override
    public Result<CloseSignalRoomResponseV2> closeRoom(CloseSignalRoomRequestV2 request) throws YunxinSdkException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("channel_id", request.getChannelId());
        queryParams.put("operator_account_id", request.getOperatorAccountId());
        if (request.getServerExtension() != null) {
            queryParams.put("server_extension", request.getServerExtension());
        }
        if (request.getOfflineEnabled() != null) {
            queryParams.put("offline_enabled", request.getOfflineEnabled().toString());
        }
        if (request.getRouteEnabled() != null) {
            queryParams.put("route_enabled", request.getRouteEnabled().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/signalling_room", "/im/v2/signalling_room", queryParams, null);
        return ResultUtils.convert(apiResponse, CloseSignalRoomResponseV2.class);
    }

    @Override
    public Result<QuerySignalRoomResponseV2> queryRoom(QuerySignalRoomRequestV2 request) throws YunxinSdkException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (request.getChannelId() != null && !request.getChannelId().trim().isEmpty()) {
            queryParams.put("channel_id", request.getChannelId());
        } else if (request.getChannelName() != null && !request.getChannelName().trim().isEmpty()) {
            queryParams.put("channel_name", request.getChannelName());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/signalling_room", "/im/v2/signalling_room", queryParams, null);
        return ResultUtils.convert(apiResponse, QuerySignalRoomResponseV2.class);
    }

    @Override
    public Result<SendSignalRoomControlResponseV2> sendControl(SendSignalRoomControlRequestV2 request) throws YunxinSdkException {
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/signalling_room/actions/control", "/im/v2/signalling_room/actions/control", null, requestBody);
        return ResultUtils.convert(apiResponse, SendSignalRoomControlResponseV2.class);
    }

    @Override
    public Result<InviteSignalRoomResponseV2> invite(InviteSignalRoomRequestV2 request) throws YunxinSdkException {
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/signalling_room/actions/invite", "/im/v2/signalling_room/actions/invite", null, requestBody);
        return ResultUtils.convert(apiResponse, InviteSignalRoomResponseV2.class);
    }

    @Override
    public Result<CancelSignalRoomInviteResponseV2> cancelInvite(CancelSignalRoomInviteRequestV2 request) throws YunxinSdkException {
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/signalling_room/actions/cancel_invite", "/im/v2/signalling_room/actions/cancel_invite", null, requestBody);
        return ResultUtils.convert(apiResponse, CancelSignalRoomInviteResponseV2.class);
    }

    @Override
    public Result<KickSignalRoomMemberResponseV2> kickMember(KickSignalRoomMemberRequestV2 request) throws YunxinSdkException {
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/signalling_room/actions/kick", "/im/v2/signalling_room/actions/kick", null, requestBody);
        return ResultUtils.convert(apiResponse, KickSignalRoomMemberResponseV2.class);
    }
}

