/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.chatroom_message;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.chatroom_message.IChatroomMessageV2Service;
import com.netease.nim.server.sdk.im.v2.chatroom_message.request.BatchSendChatroomMessagesRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_message.request.QueryChatroomHistoryMessagesRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_message.request.RecallChatroomMessageRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_message.request.SendChatroomMessageRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_message.response.BatchSendChatroomMessagesResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_message.response.QueryChatroomHistoryMessagesResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_message.response.RecallChatroomMessageResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_message.response.SendChatroomMessageResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;

public class ChatroomMessageV2Service
implements IChatroomMessageV2Service {
    private final YunxinApiHttpClient httpClient;

    public ChatroomMessageV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<SendChatroomMessageResponseV2> sendChatroomMessage(SendChatroomMessageRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/chatrooms/{room_id}/messages".replace("{room_id}", request.getRoomId().toString());
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/chatrooms/{room_id}/messages", path, null, requestBody);
        return ResultUtils.convert(apiResponse, SendChatroomMessageResponseV2.class);
    }

    @Override
    public Result<BatchSendChatroomMessagesResponseV2> batchSendChatroomMessages(BatchSendChatroomMessagesRequestV2 request) throws YunxinSdkException {
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/chatrooms/messages", "/im/v2/chatrooms/messages", null, requestBody);
        return ResultUtils.convert(apiResponse, BatchSendChatroomMessagesResponseV2.class);
    }

    @Override
    public Result<RecallChatroomMessageResponseV2> recallChatroomMessage(RecallChatroomMessageRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/chatrooms/{room_id}/messages/{message_client_id}".replace("{room_id}", request.getRoomId().toString()).replace("{message_client_id}", request.getMessageClientId());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("operator_id", request.getOperatorId());
        queryParams.put("sender_id", request.getSenderId());
        queryParams.put("create_time", request.getCreateTime().toString());
        queryParams.put("notification_enabled", request.getNotificationEnabled().toString());
        if (Boolean.TRUE.equals(request.getNotificationEnabled()) && request.getNotificationExtension() != null && !request.getNotificationExtension().isEmpty()) {
            queryParams.put("notification_extension", request.getNotificationExtension());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/chatrooms/{room_id}/messages/{message_client_id}", path, queryParams, null);
        return ResultUtils.convert(apiResponse, RecallChatroomMessageResponseV2.class);
    }

    @Override
    public Result<QueryChatroomHistoryMessagesResponseV2> queryChatroomHistoryMessages(QueryChatroomHistoryMessagesRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2.1/chatrooms/{room_id}/messages".replace("{room_id}", request.getRoomId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("sender_id", request.getSenderId());
        queryParams.put("limit", request.getLimit().toString());
        if (request.getPageToken() != null && !request.getPageToken().isEmpty()) {
            queryParams.put("page_token", request.getPageToken());
        }
        if (request.getDescending() != null) {
            queryParams.put("descending", request.getDescending().toString());
        }
        if (request.getMessageTypes() != null && !request.getMessageTypes().isEmpty()) {
            queryParams.put("message_type", request.getMessageTypes());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/chatrooms/{room_id}/messages", path, queryParams, null);
        return ResultUtils.convert(apiResponse, QueryChatroomHistoryMessagesResponseV2.class);
    }
}

