/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.chatroom;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.chatroom.IChatroomV2Service;
import com.netease.nim.server.sdk.im.v2.chatroom.request.CreateChatroomRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom.request.GetChatroomAddressRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom.request.GetChatroomInfoRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom.request.ListFixedMembersRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom.request.ListOnlineMembersRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom.request.QueryOpenChatroomsRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom.request.ToggleChatroomMuteRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom.request.ToggleInOutNotificationRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom.request.UpdateChatroomInfoRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom.request.UpdateChatroomStatusRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom.response.CreateChatroomResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom.response.GetChatroomAddressResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom.response.GetChatroomInfoResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom.response.ListFixedMembersResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom.response.ListOnlineMembersResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom.response.QueryOpenChatroomsResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom.response.ToggleChatroomMuteResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom.response.ToggleInOutNotificationResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom.response.UpdateChatroomInfoResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom.response.UpdateChatroomStatusResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;

public class ChatroomV2Service
implements IChatroomV2Service {
    private final YunxinApiHttpClient httpClient;

    public ChatroomV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<CreateChatroomResponseV2> createChatroom(CreateChatroomRequestV2 request) throws YunxinSdkException {
        if (request.getCreator() == null || request.getCreator().isEmpty()) {
            throw new IllegalArgumentException("Creator cannot be null or empty");
        }
        if (request.getRoomName() == null || request.getRoomName().isEmpty()) {
            throw new IllegalArgumentException("Room name cannot be null or empty");
        }
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/chatrooms", "/im/v2/chatrooms", null, requestBody);
        return ResultUtils.convert(apiResponse, CreateChatroomResponseV2.class);
    }

    @Override
    public Result<GetChatroomAddressResponseV2> getChatroomAddress(GetChatroomAddressRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getAccountId() == null || request.getAccountId().isEmpty()) {
            throw new IllegalArgumentException("Account ID cannot be null or empty");
        }
        if (request.getClientIp() == null || request.getClientIp().isEmpty()) {
            throw new IllegalArgumentException("Client IP cannot be null or empty");
        }
        String path = "/im/v2/chatrooms/{room_id}/actions/address".replace("{room_id}", request.getRoomId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("account_id", request.getAccountId());
        queryParams.put("client_ip", request.getClientIp());
        if (request.getClientType() != null) {
            queryParams.put("client_type", request.getClientType().toString());
        }
        if (request.getIpType() != null) {
            queryParams.put("ip_type", request.getIpType().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/chatrooms/{room_id}/actions/address", path, queryParams, null);
        return ResultUtils.convert(apiResponse, GetChatroomAddressResponseV2.class);
    }

    @Override
    public Result<GetChatroomInfoResponseV2> getChatroomInfo(GetChatroomInfoRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        String path = "/im/v2/chatrooms/{room_id}".replace("{room_id}", request.getRoomId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (request.getNeedOnlineUserCount() != null) {
            queryParams.put("need_online_user_count", request.getNeedOnlineUserCount().toString());
        }
        if (request.getOnlineUserCountByType() != null) {
            queryParams.put("online_user_count_by_type", request.getOnlineUserCountByType().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/chatrooms/{room_id}", path, queryParams, null);
        return ResultUtils.convert(apiResponse, GetChatroomInfoResponseV2.class);
    }

    @Override
    public Result<UpdateChatroomInfoResponseV2> updateChatroomInfo(UpdateChatroomInfoRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        String path = "/im/v2/chatrooms/{room_id}".replace("{room_id}", request.getRoomId().toString());
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/chatrooms/{room_id}", path, null, requestBody);
        return ResultUtils.convert(apiResponse, UpdateChatroomInfoResponseV2.class);
    }

    @Override
    public Result<UpdateChatroomStatusResponseV2> updateChatroomStatus(UpdateChatroomStatusRequestV2 request) throws YunxinSdkException {
        if (request.getOperatorAccountId() == null || request.getOperatorAccountId().isEmpty()) {
            throw new IllegalArgumentException("Operator account ID cannot be null or empty");
        }
        if (request.getValid() == null) {
            throw new IllegalArgumentException("Valid status cannot be null");
        }
        String path = "/im/v2/chatrooms/{room_id}/actions/update_status".replace("{room_id}", String.valueOf(request.getRoomId()));
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/chatrooms/{room_id}/actions/update_status", path, null, requestBody);
        return ResultUtils.convert(apiResponse, UpdateChatroomStatusResponseV2.class);
    }

    @Override
    public Result<ToggleChatroomMuteResponseV2> toggleChatroomMute(ToggleChatroomMuteRequestV2 request) throws YunxinSdkException {
        if (request.getOperatorAccountId() == null || request.getOperatorAccountId().isEmpty()) {
            throw new IllegalArgumentException("Operator account ID cannot be null or empty");
        }
        if (request.getChatBanned() == null) {
            throw new IllegalArgumentException("Chat banned status cannot be null");
        }
        String path = "/im/v2/chatrooms/{room_id}/actions/chat_banned".replace("{room_id}", String.valueOf(request.getRoomId()));
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/chatrooms/{room_id}/actions/chat_banned", path, null, requestBody);
        return ResultUtils.convert(apiResponse, ToggleChatroomMuteResponseV2.class);
    }

    @Override
    public Result<ToggleInOutNotificationResponseV2> toggleInOutNotification(ToggleInOutNotificationRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getInOutNotification() == null) {
            throw new IllegalArgumentException("In/out notification status cannot be null");
        }
        String path = "/im/v2/chatrooms/{room_id}/actions/in_out_notification".replace("{room_id}", request.getRoomId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("in_out_notification", request.getInOutNotification().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/chatrooms/{room_id}/actions/in_out_notification", path, queryParams, null);
        return ResultUtils.convert(apiResponse, ToggleInOutNotificationResponseV2.class);
    }

    @Override
    public Result<QueryOpenChatroomsResponseV2> queryOpenChatrooms(QueryOpenChatroomsRequestV2 request) throws YunxinSdkException {
        if (request.getCreatorAccountId() == null || request.getCreatorAccountId().isEmpty()) {
            throw new IllegalArgumentException("Creator account ID cannot be null or empty");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("creator_account_id", request.getCreatorAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/chatrooms/actions/opend_chatrooms", "/im/v2/chatrooms/actions/opend_chatrooms", queryParams, null);
        return ResultUtils.convert(apiResponse, QueryOpenChatroomsResponseV2.class);
    }

    @Override
    public Result<ListOnlineMembersResponseV2> listOnlineMembers(ListOnlineMembersRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getOffset() == null) {
            throw new IllegalArgumentException("Offset cannot be null");
        }
        if (request.getLimit() == null) {
            throw new IllegalArgumentException("Limit cannot be null");
        }
        String path = "/im/v2/chatrooms/{room_id}/actions/list_online_members".replace("{room_id}", request.getRoomId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("offset", request.getOffset().toString());
        queryParams.put("limit", request.getLimit().toString());
        if (request.getMemberRoles() != null && !request.getMemberRoles().isEmpty()) {
            queryParams.put("member_roles", request.getMemberRoles());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/chatrooms/{room_id}/actions/list_online_members", path, queryParams, null);
        return ResultUtils.convert(apiResponse, ListOnlineMembersResponseV2.class);
    }

    @Override
    public Result<ListFixedMembersResponseV2> listFixedMembers(ListFixedMembersRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        String path = "/im/v2/chatrooms/{room_id}/actions/list_members".replace("{room_id}", request.getRoomId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (request.getMemberRoles() != null && !request.getMemberRoles().isEmpty()) {
            queryParams.put("member_roles", request.getMemberRoles());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/chatrooms/{room_id}/actions/list_members", path, queryParams, null);
        return ResultUtils.convert(apiResponse, ListFixedMembersResponseV2.class);
    }
}

