/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.broadcast;

import com.alibaba.fastjson2.JSON;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.broadcast.IBroadcastV2Service;
import com.netease.nim.server.sdk.im.v2.broadcast.request.DeleteBroadcastNotificationRequestV2;
import com.netease.nim.server.sdk.im.v2.broadcast.request.QueryBroadcastNotificationListRequestV2;
import com.netease.nim.server.sdk.im.v2.broadcast.request.QueryBroadcastNotificationRequestV2;
import com.netease.nim.server.sdk.im.v2.broadcast.request.SendBroadcastNotificationRequestV2;
import com.netease.nim.server.sdk.im.v2.broadcast.request.SendChatroomBroadcastNotificationRequestV2;
import com.netease.nim.server.sdk.im.v2.broadcast.response.DeleteBroadcastNotificationResponseV2;
import com.netease.nim.server.sdk.im.v2.broadcast.response.QueryBroadcastNotificationListResponseV2;
import com.netease.nim.server.sdk.im.v2.broadcast.response.QueryBroadcastNotificationResponseV2;
import com.netease.nim.server.sdk.im.v2.broadcast.response.SendBroadcastNotificationResponseV2;
import com.netease.nim.server.sdk.im.v2.broadcast.response.SendChatroomBroadcastNotificationResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;

public class BroadcastV2Service
implements IBroadcastV2Service {
    private final YunxinApiHttpClient yunxinApiHttpClient;

    public BroadcastV2Service(YunxinApiHttpClient yunxinApiHttpClient) {
        this.yunxinApiHttpClient = yunxinApiHttpClient;
    }

    @Override
    public Result<SendBroadcastNotificationResponseV2> sendBroadcastNotification(SendBroadcastNotificationRequestV2 request) throws YunxinSdkException {
        if (request.getContent() == null || request.getContent().isEmpty()) {
            throw new IllegalArgumentException("Content cannot be null or empty");
        }
        String jsonRequestBody = JSON.toJSONString((Object)request);
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.POST, "/im/v2/broadcast_notification", "/im/v2/broadcast_notification", null, jsonRequestBody);
        return ResultUtils.convert(apiResponse, SendBroadcastNotificationResponseV2.class);
    }

    @Override
    public Result<DeleteBroadcastNotificationResponseV2> deleteBroadcastNotification(DeleteBroadcastNotificationRequestV2 request) throws YunxinSdkException {
        if (request.getBroadcastId() == null || request.getBroadcastId().isEmpty()) {
            throw new IllegalArgumentException("Broadcast ID cannot be null or empty");
        }
        String path = "/im/v2/broadcast_notification/{broadcast_id}".replace("{broadcast_id}", request.getBroadcastId());
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/broadcast_notification/{broadcast_id}", path, null, null);
        return ResultUtils.convert(apiResponse, DeleteBroadcastNotificationResponseV2.class);
    }

    @Override
    public Result<QueryBroadcastNotificationResponseV2> queryBroadcastNotification(QueryBroadcastNotificationRequestV2 request) throws YunxinSdkException {
        if (request.getBroadcastId() == null || request.getBroadcastId().isEmpty()) {
            throw new IllegalArgumentException("Broadcast ID cannot be null or empty");
        }
        String path = "/im/v2/broadcast_notification/{broadcast_id}".replace("{broadcast_id}", request.getBroadcastId());
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.GET, "/im/v2/broadcast_notification/{broadcast_id}", path, null, null);
        return ResultUtils.convert(apiResponse, QueryBroadcastNotificationResponseV2.class);
    }

    @Override
    public Result<QueryBroadcastNotificationListResponseV2> queryBroadcastNotificationList(QueryBroadcastNotificationListRequestV2 request) throws YunxinSdkException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (request.getPageToken() != null && !request.getPageToken().isEmpty()) {
            queryParams.put("page_token", request.getPageToken());
        }
        if (request.getLimit() != null) {
            queryParams.put("limit", request.getLimit().toString());
        }
        if (request.getType() != null) {
            queryParams.put("type", request.getType().toString());
        }
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.GET, "/im/v2/broadcast_notification", "/im/v2/broadcast_notification", queryParams, null);
        return ResultUtils.convert(apiResponse, QueryBroadcastNotificationListResponseV2.class);
    }

    @Override
    public Result<SendChatroomBroadcastNotificationResponseV2> sendChatroomBroadcastNotification(SendChatroomBroadcastNotificationRequestV2 request) throws YunxinSdkException {
        if (request.getClientBroadcastId() == null || request.getClientBroadcastId().isEmpty()) {
            throw new IllegalArgumentException("Client broadcast ID cannot be null or empty");
        }
        if (request.getSenderId() == null || request.getSenderId().isEmpty()) {
            throw new IllegalArgumentException("Sender ID cannot be null or empty");
        }
        if (request.getMessage() == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        String jsonRequestBody = JSON.toJSONString((Object)request);
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.POST, "/im/v2.1/broadcast_notification/actions/chatroom", "/im/v2.1/broadcast_notification/actions/chatroom", null, jsonRequestBody);
        return ResultUtils.convert(apiResponse, SendChatroomBroadcastNotificationResponseV2.class);
    }
}

