/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v1.message;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.im.v1.annotation.YunxinParamUtils;
import com.netease.nim.server.sdk.im.v1.message.IMessageV1Service;
import com.netease.nim.server.sdk.im.v1.message.request.BroadcastMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.message.request.DeleteBroadcastMessageByIdRequestV1;
import com.netease.nim.server.sdk.im.v1.message.request.DeleteFileRequestV1;
import com.netease.nim.server.sdk.im.v1.message.request.DeleteMessageOneWayRequestV1;
import com.netease.nim.server.sdk.im.v1.message.request.DeleteMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.message.request.DeleteRoamSessionRequestV1;
import com.netease.nim.server.sdk.im.v1.message.request.MarkReadMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.message.request.MarkReadTeamMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.message.request.RecallMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.message.request.SendBatchMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.message.request.SendMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.message.request.UploadFileRequestV1;
import com.netease.nim.server.sdk.im.v1.message.response.BroadcastMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.message.response.DeleteBroadcastMessageByIdResponseV1;
import com.netease.nim.server.sdk.im.v1.message.response.DeleteFileResponseV1;
import com.netease.nim.server.sdk.im.v1.message.response.DeleteMessageOneWayResponseV1;
import com.netease.nim.server.sdk.im.v1.message.response.DeleteMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.message.response.DeleteRoamSessionResponseV1;
import com.netease.nim.server.sdk.im.v1.message.response.MarkReadMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.message.response.MarkReadTeamMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.message.response.RecallMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.message.response.SendBatchMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.message.response.SendMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.message.response.UploadFileResponseV1;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MessageV1Service
implements IMessageV1Service {
    private final YunxinApiHttpClient httpClient;

    public MessageV1Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<SendMessageResponseV1> sendMessage(SendMessageRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getForcePushList() != null && !request.getForcePushList().isEmpty()) {
            paramMap.put("forcePushList", JSON.toJSONString(request.getForcePushList()));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/msg/sendMsg.action", paramMap)).getData())).getIntValue("code")) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        SendMessageResponseV1 response = new SendMessageResponseV1();
        if (object.containsKey("data")) {
            response = (SendMessageResponseV1)JSON.parseObject((String)object.getString("data"), SendMessageResponseV1.class);
        }
        return new Result<SendMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<SendBatchMessageResponseV1> sendBatchMessage(SendBatchMessageRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getToAccids() != null && !request.getToAccids().isEmpty()) {
            paramMap.put("toAccids", JSON.toJSONString(request.getToAccids()));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/msg/sendBatchMsg.action", paramMap)).getData())).getIntValue("code")) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        SendBatchMessageResponseV1 response = new SendBatchMessageResponseV1();
        if (object.containsKey("unregister")) {
            response.setUnregister(JSON.parseArray((String)object.getString("unregister"), String.class));
        }
        if (object.containsKey("timetag")) {
            response.setTimetag(object.getLong("timetag"));
        }
        if (object.containsKey("msgids")) {
            JSONObject msgidsObj = object.getJSONObject("msgids");
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (Map.Entry stringObjectEntry : msgidsObj.entrySet()) {
                map.put((String)stringObjectEntry.getKey(), Long.parseLong(stringObjectEntry.getValue().toString()));
            }
            response.setMsgids(map);
        }
        return new Result<SendBatchMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<MarkReadMessageResponseV1> markReadMessage(MarkReadMessageRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/msg/markReadMsg.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        MarkReadMessageResponseV1 response = new MarkReadMessageResponseV1();
        if (object.containsKey("data")) {
            response = (MarkReadMessageResponseV1)JSON.parseObject((String)object.getString("data"), MarkReadMessageResponseV1.class);
        }
        return new Result<MarkReadMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<MarkReadTeamMessageResponseV1> markReadTeamMessage(MarkReadTeamMessageRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/msg/markReadTeamMsg.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        MarkReadTeamMessageResponseV1 response = new MarkReadTeamMessageResponseV1();
        if (object.containsKey("data")) {
            JSONObject data = object.getJSONObject("data");
            JSONArray errMsgIds = data.getJSONArray("errMsgIds");
            ArrayList<Long> list = new ArrayList<Long>();
            for (Object errMsgId : errMsgIds) {
                list.add(Long.parseLong(errMsgId.toString()));
            }
            response.setErrMsgIds(list);
        }
        return new Result<MarkReadTeamMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<RecallMessageResponseV1> recallMessage(RecallMessageRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/msg/recall.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        RecallMessageResponseV1 response = new RecallMessageResponseV1();
        if (object.containsKey("data")) {
            response = (RecallMessageResponseV1)JSON.parseObject((String)object.getString("data"), RecallMessageResponseV1.class);
        }
        return new Result<RecallMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<DeleteMessageOneWayResponseV1> deleteMessageOneWay(DeleteMessageOneWayRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/msg/delMsgOneWay.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        DeleteMessageOneWayResponseV1 response = new DeleteMessageOneWayResponseV1();
        if (object.containsKey("data")) {
            response = (DeleteMessageOneWayResponseV1)JSON.parseObject((String)object.getString("data"), DeleteMessageOneWayResponseV1.class);
        }
        return new Result<DeleteMessageOneWayResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<BroadcastMessageResponseV1> broadcastMessage(BroadcastMessageRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getTargetOs() != null && !request.getTargetOs().isEmpty()) {
            paramMap.put("targetOs", JSON.toJSONString(request.getTargetOs()));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/msg/broadcastMsg.action", paramMap)).getData())).getIntValue("code")) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        BroadcastMessageResponseV1 response = new BroadcastMessageResponseV1();
        if (object.containsKey("msg")) {
            JSONObject msgObj = object.getJSONObject("msg");
            if (msgObj.containsKey("broadcastId")) {
                response.setBroadcastId(msgObj.getLong("broadcastId"));
            }
            if (msgObj.containsKey("from")) {
                response.setFrom(msgObj.getString("from"));
            }
            if (msgObj.containsKey("body")) {
                response.setBody(msgObj.getString("body"));
            }
            if (msgObj.containsKey("targetOs")) {
                response.setTargetOs(JSON.parseArray((String)msgObj.getString("targetOs"), String.class));
            }
            if (msgObj.containsKey("isOffline")) {
                response.setIsOffline(msgObj.getBoolean("isOffline"));
            }
            if (msgObj.containsKey("createTime")) {
                response.setCreateTime(msgObj.getLong("createTime"));
            }
            if (msgObj.containsKey("expireTime")) {
                response.setExpireTime(msgObj.getLong("expireTime"));
            }
        }
        return new Result<BroadcastMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<DeleteBroadcastMessageByIdResponseV1> deleteBroadcastMessageById(DeleteBroadcastMessageByIdRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/history/delBroadcastMsgById.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        DeleteBroadcastMessageByIdResponseV1 response = new DeleteBroadcastMessageByIdResponseV1();
        if (object.containsKey("data")) {
            response = (DeleteBroadcastMessageByIdResponseV1)JSON.parseObject((String)object.getString("data"), DeleteBroadcastMessageByIdResponseV1.class);
        }
        return new Result<DeleteBroadcastMessageByIdResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<UploadFileResponseV1> uploadFile(UploadFileRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/msg/upload.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        UploadFileResponseV1 response = new UploadFileResponseV1();
        if (object.containsKey("url")) {
            response.setUrl(object.getString("url"));
        }
        return new Result<UploadFileResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<DeleteFileResponseV1> deleteFile(DeleteFileRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/job/nos/del.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        DeleteFileResponseV1 response = new DeleteFileResponseV1();
        if (object.containsKey("data")) {
            response = (DeleteFileResponseV1)JSON.parseObject((String)object.getString("data"), DeleteFileResponseV1.class);
        }
        return new Result<DeleteFileResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<DeleteMessageResponseV1> deleteMessage(DeleteMessageRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/msg/delMsg.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        DeleteMessageResponseV1 response = new DeleteMessageResponseV1();
        if (object.containsKey("data")) {
            response = (DeleteMessageResponseV1)JSON.parseObject((String)object.getString("data"), DeleteMessageResponseV1.class);
        }
        return new Result<DeleteMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<DeleteRoamSessionResponseV1> deleteRoamSession(DeleteRoamSessionRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/msg/delRoamSession.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        DeleteRoamSessionResponseV1 response = new DeleteRoamSessionResponseV1();
        if (object.containsKey("data")) {
            response = (DeleteRoamSessionResponseV1)JSON.parseObject((String)object.getString("data"), DeleteRoamSessionResponseV1.class);
        }
        return new Result<DeleteRoamSessionResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }
}

