/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v1.event_subscribe;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.im.v1.annotation.YunxinParamUtils;
import com.netease.nim.server.sdk.im.v1.event_subscribe.IEventSubscribeV1Service;
import com.netease.nim.server.sdk.im.v1.event_subscribe.request.AddEventSubscribeRequestV1;
import com.netease.nim.server.sdk.im.v1.event_subscribe.request.BatchDeleteEventSubscribeRequestV1;
import com.netease.nim.server.sdk.im.v1.event_subscribe.request.DeleteEventSubscribeRequestV1;
import com.netease.nim.server.sdk.im.v1.event_subscribe.request.QueryEventSubscribeRequestV1;
import com.netease.nim.server.sdk.im.v1.event_subscribe.response.AddEventSubscribeResponseV1;
import com.netease.nim.server.sdk.im.v1.event_subscribe.response.BatchDeleteEventSubscribeResponseV1;
import com.netease.nim.server.sdk.im.v1.event_subscribe.response.DeleteEventSubscribeResponseV1;
import com.netease.nim.server.sdk.im.v1.event_subscribe.response.QueryEventSubscribeResponseV1;
import java.util.Map;

public class EventSubscribeV1Service
implements IEventSubscribeV1Service {
    private final YunxinApiHttpClient httpClient;

    public EventSubscribeV1Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<AddEventSubscribeResponseV1> addEventSubscribe(AddEventSubscribeRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getPublisherAccids() != null) {
            paramMap.put("publisherAccids", JSON.toJSONString(request.getPublisherAccids()));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/event/subscribe/add.action", paramMap)).getData())).getIntValue("code")) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        AddEventSubscribeResponseV1 response = new AddEventSubscribeResponseV1();
        if (object.containsKey("failedAccid")) {
            response.setFailedAccid(object.getList("failedAccid", String.class, new JSONReader.Feature[0]));
        }
        return new Result<AddEventSubscribeResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryEventSubscribeResponseV1> queryEventSubscribe(QueryEventSubscribeRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getPublisherAccids() != null) {
            paramMap.put("publisherAccids", JSON.toJSONString(request.getPublisherAccids()));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/event/subscribe/query.action", paramMap)).getData())).getIntValue("code")) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        QueryEventSubscribeResponseV1 response = new QueryEventSubscribeResponseV1();
        if (object.containsKey("subscribes")) {
            response.setSubscribes(JSON.parseArray((String)object.getString("subscribes"), QueryEventSubscribeResponseV1.Subscription.class));
        }
        return new Result<QueryEventSubscribeResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<DeleteEventSubscribeResponseV1> deleteEventSubscribe(DeleteEventSubscribeRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getPublisherAccids() != null) {
            paramMap.put("publisherAccids", JSON.toJSONString(request.getPublisherAccids()));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/event/subscribe/delete.action", paramMap)).getData())).getIntValue("code")) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        DeleteEventSubscribeResponseV1 response = new DeleteEventSubscribeResponseV1();
        if (object.containsKey("failedAccid")) {
            response.setFailedAccid(object.getList("failedAccid", String.class, new JSONReader.Feature[0]));
        }
        return new Result<DeleteEventSubscribeResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<BatchDeleteEventSubscribeResponseV1> batchDeleteEventSubscribe(BatchDeleteEventSubscribeRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/event/subscribe/batchdel.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        BatchDeleteEventSubscribeResponseV1 response = new BatchDeleteEventSubscribeResponseV1();
        return new Result<BatchDeleteEventSubscribeResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }
}

