/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import okhttp3.internal.connection.RouteException;

public class ExceptionUtils {
    public static Throwable getRealCause(Throwable e) {
        while (true) {
            if (e instanceof RouteException) {
                if (e.getCause() == null) break;
                e = e.getCause();
                continue;
            }
            if (e instanceof ExecutionException) {
                if (e.getCause() == null) break;
                e = e.getCause();
                continue;
            }
            if (e instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e).getTargetException();
                if (targetException == null) break;
                e = targetException;
                continue;
            }
            if (!(e instanceof UndeclaredThrowableException) || e.getCause() == null) break;
            e = e.getCause();
        }
        return e;
    }

    public static boolean isConnectError(Throwable t) {
        Throwable cause = ExceptionUtils.getRealCause(t);
        if (cause instanceof ConnectException) {
            return true;
        }
        if (cause instanceof UnknownHostException) {
            return true;
        }
        if (cause instanceof SocketTimeoutException) {
            String message = cause.getMessage();
            return message != null && message.contains("connect timed out");
        }
        return false;
    }

    public static boolean isTimeoutError(Throwable t) {
        Throwable cause = ExceptionUtils.getRealCause(t);
        return cause instanceof SocketTimeoutException;
    }
}

