/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core.metrics;

import com.netease.nim.server.sdk.core.metrics.StatsData;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class Statistics {
    private final LongAdder count = new LongAdder();
    private final LongAdder sum = new LongAdder();
    private final MaxValue maxValue = new MaxValue();
    private final AtomicLong[] distribute;
    private final boolean exact;

    public Statistics(boolean exact, int expectMaxValue) {
        this.exact = exact;
        this.distribute = exact ? new AtomicLong[expectMaxValue] : new AtomicLong[256];
        for (int i = 0; i < this.distribute.length; ++i) {
            this.distribute[i] = new AtomicLong(0L);
        }
    }

    public Statistics() {
        this(false, -1);
    }

    public void update(long value) {
        this.count.increment();
        this.sum.add(value);
        this.maxValue.update(value);
        if (value < 0L) {
            return;
        }
        if (this.exact) {
            AtomicLong distributeCounter = value >= (long)this.distribute.length ? this.distribute[this.distribute.length - 1] : this.distribute[(int)value];
            if (distributeCounter != null) {
                distributeCounter.incrementAndGet();
            }
        } else {
            AtomicLong distributeCounter = value <= 100L ? this.distribute[(int)value] : (value <= 200L ? this.distribute[(int)(101L + (value - 101L) / 5L)] : (value <= 500L ? this.distribute[(int)(121L + (value - 201L) / 10L)] : (value <= 3000L ? this.distribute[(int)(151L + (value - 501L) / 50L)] : (value <= 10000L ? this.distribute[(int)(201L + (value - 3001L) / 200L)] : (value <= 30000L ? this.distribute[(int)(236L + (value - 10001L) / 1000L)] : this.distribute[255])))));
            if (distributeCounter != null) {
                distributeCounter.incrementAndGet();
            }
        }
    }

    public StatsData getStatsDataAndReset() {
        long sum = this.sum.sumThenReset();
        long count = this.count.sumThenReset();
        long max = this.maxValue.getAndSet(0L);
        double avg = count == 0L ? 0.0 : (double)sum / (double)count;
        long p50Position = (long)((double)count * 0.5);
        long p75Position = (long)((double)count * 0.75);
        long p90Position = (long)((double)count * 0.9);
        long p95Position = (long)((double)count * 0.95);
        long p99Position = (long)((double)count * 0.99);
        long p999Position = (long)((double)count * 0.999);
        long p50 = -1L;
        long p75 = -1L;
        long p90 = -1L;
        long p95 = -1L;
        long p99 = -1L;
        long p999 = -1L;
        if (this.exact) {
            long c = 0L;
            long lastIndexNum = this.distribute[this.distribute.length - 1].get();
            for (int i = 0; i < this.distribute.length; ++i) {
                if (p50 == -1L && (c += this.distribute[i].getAndSet(0L)) >= p50Position) {
                    p50 = i;
                }
                if (p75 == -1L && c >= p75Position) {
                    p75 = i;
                }
                if (p90 == -1L && c >= p90Position) {
                    p90 = i;
                }
                if (p95 == -1L && c >= p95Position) {
                    p95 = i;
                }
                if (p99 == -1L && c >= p99Position) {
                    p99 = i;
                }
                if (p999 != -1L || c < p999Position) continue;
                p999 = i;
            }
            if (p50 == (long)(this.distribute.length - 1)) {
                p50 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p50Position);
            }
            if (p75 == (long)(this.distribute.length - 1)) {
                p75 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p75Position);
            }
            if (p90 == (long)(this.distribute.length - 1)) {
                p90 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p90Position);
            }
            if (p95 == (long)(this.distribute.length - 1)) {
                p95 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p95Position);
            }
            if (p99 == (long)(this.distribute.length - 1)) {
                p99 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p99Position);
            }
            if (p999 == (long)(this.distribute.length - 1)) {
                p999 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p999Position);
            }
            return new StatsData(count, avg, max, sum, p50, p75, p90, p95, p99, p999);
        }
        long c = 0L;
        for (int i = 0; i < this.distribute.length; ++i) {
            long offset;
            long current = this.distribute[i].getAndSet(0L);
            if (p50 == -1L && (c += current) >= p50Position) {
                offset = current - (c - p50Position);
                p50 = this.index2Real(i, current, offset, max);
            }
            if (p75 == -1L && c >= p75Position) {
                offset = current - (c - p75Position);
                p75 = this.index2Real(i, current, offset, max);
            }
            if (p90 == -1L && c >= p90Position) {
                offset = current - (c - p90Position);
                p90 = this.index2Real(i, current, offset, max);
            }
            if (p95 == -1L && c >= p95Position) {
                offset = current - (c - p95Position);
                p95 = this.index2Real(i, current, offset, max);
            }
            if (p99 == -1L && c >= p99Position) {
                offset = current - (c - p99Position);
                p99 = this.index2Real(i, current, offset, max);
            }
            if (p999 != -1L || c < p999Position) continue;
            offset = current - (c - p999Position);
            p999 = this.index2Real(i, current, offset, max);
        }
        return new StatsData(count, avg, max, sum, p50, p75, p90, p95, p99, p999);
    }

    private long index2Real(int index, long current, long offset, long max) {
        if (index >= 0 && index <= 100) {
            return index;
        }
        if (index <= 121) {
            double rate = (double)offset / ((double)current * 1.0);
            return 100L + (long)(index - 100 + 1) * 5L + (long)(5.0 * rate);
        }
        if (index <= 151) {
            double rate = (double)offset / ((double)current * 1.0);
            return 200L + (long)(index - 121 + 1) * 10L + (long)(10.0 * rate);
        }
        if (index <= 201) {
            double rate = (double)offset / ((double)current * 1.0);
            return 500L + (long)(index - 151 + 1) * 50L + (long)(50.0 * rate);
        }
        if (index <= 236) {
            double rate = (double)offset / ((double)current * 1.0);
            return 3000L + (long)(index - 201 + 1) * 200L + (long)(200.0 * rate);
        }
        if (index < 255) {
            double rate = (double)offset / ((double)current * 1.0);
            return 3000L + (long)(index - 236 + 1) * 1000L + (long)(1000.0 * rate);
        }
        if (index == 255) {
            return 30000L + (long)((double)offset / ((double)current * 1.0) * (double)(max - 30000L));
        }
        return 0L;
    }

    private long quantileExceed(long max, int maxIndex, long lastIndexNum, long count, long quantilePosition) {
        return Math.round((double)max - (double)(max - (long)maxIndex + 1L) / ((double)lastIndexNum * 1.0) * (double)(count - quantilePosition));
    }

    public StatsData getStatsData() {
        long sum = this.sum.sum();
        long count = this.count.sum();
        long max = this.maxValue.get();
        double avg = (double)sum / (double)count;
        long p50Position = (long)((double)count * 0.5);
        long p75Position = (long)((double)count * 0.75);
        long p90Position = (long)((double)count * 0.9);
        long p95Position = (long)((double)count * 0.95);
        long p99Position = (long)((double)count * 0.99);
        long p999Position = (long)((double)count * 0.999);
        long p50 = -1L;
        long p75 = -1L;
        long p90 = -1L;
        long p95 = -1L;
        long p99 = -1L;
        long p999 = -1L;
        long c = 0L;
        if (this.exact) {
            long lastIndexNum = this.distribute[this.distribute.length - 1].get();
            for (int i = 0; i < this.distribute.length; ++i) {
                if (p50 == -1L && (c += this.distribute[i].get()) >= p50Position) {
                    p50 = i;
                }
                if (p75 == -1L && c >= p75Position) {
                    p75 = i;
                }
                if (p90 == -1L && c >= p90Position) {
                    p90 = i;
                }
                if (p95 == -1L && c >= p95Position) {
                    p95 = i;
                }
                if (p99 == -1L && c >= p99Position) {
                    p99 = i;
                }
                if (p999 != -1L || c < p999Position) continue;
                p999 = i;
            }
            if (p50 == (long)(this.distribute.length - 1)) {
                p50 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p50Position);
            }
            if (p75 == (long)(this.distribute.length - 1)) {
                p75 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p75Position);
            }
            if (p90 == (long)(this.distribute.length - 1)) {
                p90 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p90Position);
            }
            if (p95 == (long)(this.distribute.length - 1)) {
                p95 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p95Position);
            }
            if (p99 == (long)(this.distribute.length - 1)) {
                p99 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p99Position);
            }
            if (p999 == (long)(this.distribute.length - 1)) {
                p999 = this.quantileExceed(max, this.distribute.length - 1, lastIndexNum, count, p999Position);
            }
        } else {
            for (int i = 0; i < this.distribute.length; ++i) {
                long offset;
                long current = this.distribute[i].get();
                if (p50 == -1L && (c += current) >= p50Position) {
                    offset = current - (c - p50Position);
                    p50 = this.index2Real(i, current, offset, max);
                }
                if (p75 == -1L && c >= p75Position) {
                    offset = current - (c - p75Position);
                    p75 = this.index2Real(i, current, offset, max);
                }
                if (p90 == -1L && c >= p90Position) {
                    offset = current - (c - p90Position);
                    p90 = this.index2Real(i, current, offset, max);
                }
                if (p95 == -1L && c >= p95Position) {
                    offset = current - (c - p95Position);
                    p95 = this.index2Real(i, current, offset, max);
                }
                if (p99 == -1L && c >= p99Position) {
                    offset = current - (c - p99Position);
                    p99 = this.index2Real(i, current, offset, max);
                }
                if (p999 != -1L || c < p999Position) continue;
                offset = current - (c - p999Position);
                p999 = this.index2Real(i, current, offset, max);
            }
        }
        return new StatsData(count, avg, max, sum, p50, p75, p90, p95, p99, p999);
    }

    private static class MaxValue {
        private final AtomicLong max = new AtomicLong(0L);

        private MaxValue() {
        }

        public void update(long value) {
            long oldValue;
            while (value > (oldValue = this.max.get()) && !this.max.compareAndSet(oldValue, value)) {
            }
        }

        public long getAndSet(long newValue) {
            return this.max.getAndSet(newValue);
        }

        public long get() {
            return this.max.get();
        }
    }
}

