/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core;

import com.netease.nim.server.sdk.core.BizName;
import com.netease.nim.server.sdk.core.EndpointConfig;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.YunxinHttpClient;
import com.netease.nim.server.sdk.core.YunxinHttpClientConfig;
import com.netease.nim.server.sdk.core.endpoint.DynamicEndpointFetcher;
import com.netease.nim.server.sdk.core.endpoint.DynamicEndpointSelector;
import com.netease.nim.server.sdk.core.endpoint.EndpointSelector;
import com.netease.nim.server.sdk.core.endpoint.FixedEndpointSelector;
import com.netease.nim.server.sdk.core.endpoint.Region;
import com.netease.nim.server.sdk.core.endpoint.RetryPolicy;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.ContextType;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.core.http.HttpResponse;
import com.netease.nim.server.sdk.core.http.ParamBuilder;
import com.netease.nim.server.sdk.core.metrics.MetricsCallback;
import com.netease.nim.server.sdk.core.metrics.MetricsConfig;
import com.netease.nim.server.sdk.core.metrics.Stats;
import com.netease.nim.server.sdk.core.trace.ApiVersion;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class YunxinApiHttpClient {
    private static final ConcurrentHashMap<String, YunxinApiHttpClient> clientMap = new ConcurrentHashMap();
    private final BizName bizName;
    private final YunxinHttpClient httpClient;
    private final String duplicateKey;

    private YunxinApiHttpClient(BizName bizName, String appkey, String appsecret, EndpointConfig endpointConfig, YunxinHttpClientConfig httpClientConfig, MetricsConfig metricsConfig) {
        this.bizName = bizName;
        this.httpClient = new YunxinHttpClient(bizName, appkey, appsecret, endpointConfig, httpClientConfig, metricsConfig);
        this.duplicateKey = appkey + "/" + appsecret + "/" + bizName.getValue();
    }

    public final YunxinApiResponse executeV1Api(String path, Map<String, String> paramMap) throws YunxinSdkException {
        if (this.bizName != BizName.IM) {
            throw new IllegalStateException("only support bizName = IM");
        }
        ParamBuilder builder = new ParamBuilder();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            builder.addParam(entry.getKey(), entry.getValue());
        }
        HttpResponse response = this.httpClient.execute(HttpMethod.POST, ContextType.form_url_encoded, ApiVersion.V1, path, path, null, builder.build());
        return new YunxinApiResponse(response.getEndpoint(), response.getHttpCode(), response.getData(), response.getTraceId());
    }

    public final YunxinApiResponse executeV2Api(HttpMethod method, String uri, String path, Map<String, String> queryString, String data) throws YunxinSdkException {
        if (this.bizName != BizName.IM) {
            throw new IllegalStateException("only support bizName = IM");
        }
        HttpResponse response = this.httpClient.execute(method, ContextType.json, ApiVersion.V2, uri, path, queryString, data);
        return new YunxinApiResponse(response.getEndpoint(), response.getHttpCode(), response.getData(), response.getTraceId());
    }

    public final YunxinApiResponse execute(HttpMethod method, ContextType contextType, String uri, String path, Map<String, String> queryString, String data) throws YunxinSdkException {
        HttpResponse response = this.httpClient.execute(method, contextType, ApiVersion.V1, uri, path, queryString, data);
        return new YunxinApiResponse(response.getEndpoint(), response.getHttpCode(), response.getData(), response.getTraceId());
    }

    public final YunxinApiResponse executeJson(HttpMethod method, String uri, String path, Map<String, String> queryString, String data) throws YunxinSdkException {
        HttpResponse response = this.httpClient.execute(method, ContextType.json, ApiVersion.V1, uri, path, queryString, data);
        return new YunxinApiResponse(response.getEndpoint(), response.getHttpCode(), response.getData(), response.getTraceId());
    }

    public final YunxinApiResponse executeJson(HttpMethod method, String path, Map<String, String> queryString, String data) throws YunxinSdkException {
        HttpResponse response = this.httpClient.execute(method, ContextType.json, ApiVersion.V1, path, path, queryString, data);
        return new YunxinApiResponse(response.getEndpoint(), response.getHttpCode(), response.getData(), response.getTraceId());
    }

    public final YunxinApiResponse executeForm(HttpMethod method, String uri, String path, Map<String, String> queryString, String data) throws YunxinSdkException {
        HttpResponse response = this.httpClient.execute(method, ContextType.form_url_encoded, ApiVersion.V1, uri, path, queryString, data);
        return new YunxinApiResponse(response.getEndpoint(), response.getHttpCode(), response.getData(), response.getTraceId());
    }

    public final YunxinApiResponse executeForm(HttpMethod method, String path, Map<String, String> queryString, String data) throws YunxinSdkException {
        HttpResponse response = this.httpClient.execute(method, ContextType.form_url_encoded, ApiVersion.V1, path, path, queryString, data);
        return new YunxinApiResponse(response.getEndpoint(), response.getHttpCode(), response.getData(), response.getTraceId());
    }

    public final Stats getStats() {
        return this.httpClient.getStats();
    }

    public final void shutdown() {
        this.httpClient.shutdown();
        clientMap.remove(this.duplicateKey);
    }

    public static class Builder {
        private final BizName bizName;
        private final String appkey;
        private final String appsecret;
        private final EndpointConfig endpointConfig = new EndpointConfig();
        private YunxinHttpClientConfig httpClientConfig = new YunxinHttpClientConfig();
        private final MetricsConfig metricsConfig = new MetricsConfig();
        private Region region;

        public Builder(BizName bizName, String appkey, String appsecret) {
            this.bizName = bizName;
            this.appkey = appkey;
            this.appsecret = appsecret;
            if (bizName != BizName.CUSTOM) {
                String cacheKey = appkey + "/" + appsecret + "/" + bizName.getValue();
                YunxinApiHttpClient client = (YunxinApiHttpClient)clientMap.get(cacheKey);
                if (client != null) {
                    throw new IllegalStateException("YunxinApiHttpClient with appkey = [" + appkey + "] and bizName = [" + bizName.name() + "] duplicate init");
                }
            }
            this.endpointConfig.setRetryPolicy(bizName.getDefaultRetryPolicy());
        }

        public Builder(String appkey, String appsecret) {
            this(BizName.IM, appkey, appsecret);
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            if (retryPolicy == null) {
                throw new IllegalArgumentException("retry policy null");
            }
            this.endpointConfig.setRetryPolicy(retryPolicy);
            return this;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint == null) {
                throw new IllegalArgumentException("retry policy null");
            }
            this.endpointConfig.setEndpointSelector(new FixedEndpointSelector(endpoint));
            return this;
        }

        public Builder endpointSelector(EndpointSelector endpointSelector) {
            if (endpointSelector == null) {
                throw new IllegalArgumentException("endpointSelector null");
            }
            this.endpointConfig.setEndpointSelector(endpointSelector);
            return this;
        }

        public Builder timeoutMillis(int timeoutMillis) {
            if (timeoutMillis <= 0) {
                throw new IllegalArgumentException("illegal timeoutMillis");
            }
            this.httpClientConfig.setConnectTimeoutMillis(timeoutMillis);
            this.httpClientConfig.setReadTimeoutMillis(timeoutMillis);
            this.httpClientConfig.setWriteTimeoutMillis(timeoutMillis);
            return this;
        }

        public Builder httpClientConfig(YunxinHttpClientConfig httpClientConfig) {
            if (httpClientConfig == null) {
                throw new IllegalArgumentException("httpClientConfig null");
            }
            this.httpClientConfig = httpClientConfig;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            if (proxy == null) {
                throw new IllegalArgumentException("proxy is null");
            }
            this.httpClientConfig.setProxy(proxy);
            return this;
        }

        public Builder proxySelector(ProxySelector proxySelector) {
            if (proxySelector == null) {
                throw new IllegalArgumentException("proxySelector is null");
            }
            this.httpClientConfig.setProxySelector(proxySelector);
            return this;
        }

        public Builder metricEnable(boolean enable) {
            this.metricsConfig.setEnable(enable);
            return this;
        }

        public Builder metricCollectIntervalSeconds(int collectIntervalSeconds) {
            if (collectIntervalSeconds <= 0) {
                throw new IllegalArgumentException("illegal collectIntervalSeconds");
            }
            this.metricsConfig.setCollectIntervalSeconds(collectIntervalSeconds);
            return this;
        }

        public Builder metricsCallback(MetricsCallback metricsCallback) {
            this.metricsConfig.setMetricsCallback(metricsCallback);
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public YunxinApiHttpClient build() {
            YunxinApiHttpClient client;
            String cacheKey = this.appkey + "/" + this.appsecret + "/" + this.bizName.getValue();
            if (this.bizName != BizName.CUSTOM && (client = (YunxinApiHttpClient)clientMap.get(cacheKey)) != null) {
                throw new IllegalStateException("YunxinApiHttpClient with appkey = [" + this.appkey + "] and bizName = [" + this.bizName.name() + "] duplicate init");
            }
            if (this.bizName == BizName.CUSTOM && this.endpointConfig.getEndpointSelector() == null) {
                throw new IllegalArgumentException("bizName with CUSTOM must specify endpoints");
            }
            if (this.endpointConfig.getEndpointSelector() == null) {
                DynamicEndpointSelector endpointSelector = new DynamicEndpointSelector(this.bizName, new DynamicEndpointFetcher(this.bizName, this.appkey, this.region));
                this.endpointConfig.setEndpointSelector(endpointSelector);
            }
            YunxinApiHttpClient yunxinApiHttpClient = new YunxinApiHttpClient(this.bizName, this.appkey, this.appsecret, this.endpointConfig, this.httpClientConfig, this.metricsConfig);
            if (this.bizName != BizName.CUSTOM) {
                clientMap.put(cacheKey, yunxinApiHttpClient);
            }
            return yunxinApiHttpClient;
        }
    }
}

