/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.flink.shuffle;

import com.netease.arctic.data.ChangeAction;
import com.netease.arctic.flink.shuffle.RowKindUtil;
import com.netease.arctic.log.FormatVersion;
import com.netease.arctic.log.LogData;
import com.netease.arctic.log.data.LogArrayData;
import com.netease.arctic.log.data.LogMapData;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.flink.shaded.guava18.com.google.common.base.Preconditions;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.iceberg.relocated.com.google.common.primitives.Longs;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class LogRecordV1
implements LogData<RowData>,
Serializable {
    private static final long serialVersionUID = -3884886938053319336L;
    FormatVersion formatVersion;
    byte[] upstreamId;
    long epicNo;
    private boolean flip;
    private ChangeAction changeAction;
    private transient RowData actualValue;
    public static final LogData.FieldGetterFactory<RowData> fieldGetterFactory = new LogData.FieldGetterFactory<RowData>(){
        private static final long serialVersionUID = 1L;

        public LogData.FieldGetter<RowData> createFieldGetter(Type type, int pos) {
            LogData.FieldGetter & Serializable fieldGetter;
            switch (type.typeId()) {
                case BOOLEAN: {
                    fieldGetter = RowData::getBoolean;
                    break;
                }
                case INTEGER: 
                case DATE: {
                    fieldGetter = RowData::getInt;
                    break;
                }
                case LONG: 
                case TIME: {
                    fieldGetter = RowData::getLong;
                    break;
                }
                case FLOAT: {
                    fieldGetter = RowData::getFloat;
                    break;
                }
                case DOUBLE: {
                    fieldGetter = RowData::getDouble;
                    break;
                }
                case TIMESTAMP: {
                    Types.TimestampType timestamp = (Types.TimestampType)type;
                    if (timestamp.shouldAdjustToUTC()) {
                        return (LogData.FieldGetter & Serializable)(row, fieldPos) -> {
                            if (row.isNullAt(fieldPos)) {
                                return null;
                            }
                            return row.getTimestamp(fieldPos, 9).toInstant();
                        };
                    }
                    return (LogData.FieldGetter & Serializable)(row, fieldPos) -> {
                        if (row.isNullAt(fieldPos)) {
                            return null;
                        }
                        return row.getTimestamp(fieldPos, 9).toLocalDateTime();
                    };
                }
                case STRING: {
                    fieldGetter = RowData::getString;
                    break;
                }
                case UUID: 
                case FIXED: 
                case BINARY: {
                    fieldGetter = RowData::getBinary;
                    break;
                }
                case DECIMAL: {
                    fieldGetter = (LogData.FieldGetter & Serializable)(row, fieldPos) -> {
                        int scale;
                        Types.DecimalType decimalType = (Types.DecimalType)type;
                        int precision = decimalType.precision();
                        DecimalData decimalData = row.getDecimal(fieldPos, precision, scale = decimalType.scale());
                        return decimalData == null ? null : decimalData.toBigDecimal();
                    };
                    break;
                }
                case LIST: {
                    fieldGetter = (LogData.FieldGetter & Serializable)(row, fieldPos) -> {
                        ArrayData arrayData = row.getArray(fieldPos);
                        if (arrayData == null) {
                            return null;
                        }
                        return new LogFlinkArrayData(arrayData);
                    };
                    break;
                }
                case MAP: {
                    fieldGetter = (LogData.FieldGetter & Serializable)(row, fieldPos) -> {
                        MapData mapData = row.getMap(pos);
                        if (mapData == null) {
                            return null;
                        }
                        return new LogFlinkMapData(mapData);
                    };
                    break;
                }
                case STRUCT: {
                    fieldGetter = (LogData.FieldGetter & Serializable)(row, fieldPos) -> row.getRow(fieldPos, 0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not supported type:" + type);
                }
            }
            return (LogData.FieldGetter & Serializable)(row, fieldPos) -> {
                if (row.isNullAt(fieldPos)) {
                    return null;
                }
                return fieldGetter.getFieldOrNull(row, fieldPos);
            };
        }
    };
    public static LogData.Factory<RowData> factory = new LogData.Factory<RowData>(){
        private static final long serialVersionUID = 2395276763978332852L;

        public RowData createActualValue(Object[] objects, Type[] fieldTypes) {
            Preconditions.checkNotNull((Object)objects);
            Preconditions.checkArgument((objects.length > 0 ? 1 : 0) != 0, (Object)"can't construct a instance used by GenericRowData.");
            GenericRowData row = new GenericRowData(objects.length);
            for (int i = 0; i < objects.length; ++i) {
                Object obj = objects[i];
                Type type = fieldTypes[i];
                obj = this.wrapIntoNullableConvert(type, obj);
                row.setField(i, obj);
            }
            return row;
        }

        public Object wrapIntoNullableConvert(Type primitiveType, Object object) {
            if (object == null) {
                return null;
            }
            return this.convertIfNecessary(primitiveType, object);
        }

        public Object convertIfNecessary(Type primitiveType, Object obj) {
            switch (primitiveType.typeId()) {
                case STRING: {
                    obj = StringData.fromString((String)obj.toString());
                    break;
                }
                case TIME: {
                    obj = (int)((Long)obj / 10001000L);
                    break;
                }
                case TIMESTAMP: {
                    Types.TimestampType timestamp = (Types.TimestampType)primitiveType;
                    if (timestamp.shouldAdjustToUTC()) {
                        obj = TimestampData.fromInstant((Instant)((Instant)obj));
                        break;
                    }
                    obj = TimestampData.fromLocalDateTime((LocalDateTime)((LocalDateTime)obj));
                    break;
                }
                case DECIMAL: {
                    Types.DecimalType decimalType = (Types.DecimalType)primitiveType;
                    int precision = decimalType.precision();
                    int scale = decimalType.scale();
                    obj = DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)obj), (int)precision, (int)scale);
                    break;
                }
                case LIST: {
                    assert (obj instanceof LogFlinkArrayData);
                    LogFlinkArrayData list = (LogFlinkArrayData)obj;
                    obj = list.arrayData;
                    break;
                }
                case MAP: {
                    assert (obj instanceof LogFlinkMapData);
                    LogFlinkMapData map = (LogFlinkMapData)obj;
                    obj = map.mapData;
                }
            }
            return obj;
        }

        public LogData<RowData> create(RowData rowData, Object ... headers) {
            FormatVersion formatVersion = FormatVersion.fromBytes((byte[])((byte[])headers[0]));
            if (formatVersion == null) {
                throw new FlinkRuntimeException(String.format("this is illegal format version, %s.", headers[0]));
            }
            return new LogRecordV1(formatVersion, (byte[])headers[1], (Long)headers[2], (Boolean)headers[3], ChangeAction.fromByteValue((byte)((Byte)headers[4])), rowData);
        }

        public Class<?> getActualValueClass() {
            return RowData.class;
        }
    };
    public static LogArrayData.Factory arrayFactory = new LogArrayData.Factory(){
        private static final long serialVersionUID = 1L;

        public LogArrayData create(Object[] array) {
            GenericArrayData flinkArrayData = new GenericArrayData(array);
            return new LogFlinkArrayData((ArrayData)flinkArrayData);
        }
    };
    public static LogMapData.Factory mapFactory = new LogMapData.Factory(){
        private static final long serialVersionUID = 1L;

        public LogMapData create(Map<Object, Object> result) {
            GenericMapData flinkMapData = new GenericMapData(result);
            return new LogFlinkMapData((MapData)flinkMapData);
        }
    };

    public LogRecordV1(FormatVersion version, byte[] upstreamId, long epicNo, boolean flip, ChangeAction changeAction, RowData actualValue) {
        this.formatVersion = (FormatVersion)Preconditions.checkNotNull((Object)version);
        this.upstreamId = (byte[])Preconditions.checkNotNull((Object)upstreamId);
        this.epicNo = epicNo;
        this.flip = flip;
        this.changeAction = (ChangeAction)Preconditions.checkNotNull((Object)changeAction);
        if (actualValue != null) {
            this.actualValue = actualValue;
            this.actualValue.setRowKind(RowKindUtil.convertToFlinkRowKind(changeAction));
        }
    }

    public String getVersion() {
        return this.formatVersion.asString();
    }

    public byte[] getVersionBytes() {
        return this.formatVersion.asBytes();
    }

    public String getUpstreamId() {
        return new String(this.upstreamId);
    }

    public byte[] getUpstreamIdBytes() {
        return this.upstreamId;
    }

    public long getEpicNo() {
        return this.epicNo;
    }

    public byte[] getEpicNoBytes() {
        return Longs.toByteArray((long)this.epicNo);
    }

    public boolean getFlip() {
        return this.flip;
    }

    public byte getFlipByte() {
        return this.flip ? (byte)1 : 0;
    }

    public ChangeAction getChangeAction() {
        return this.changeAction;
    }

    public byte getChangeActionByte() {
        return this.changeAction.toByteValue();
    }

    public RowData getActualValue() {
        return this.actualValue;
    }

    public String toString() {
        return "LogData = {version = " + this.getVersion() + ", upstreamId = " + this.getUpstreamId() + ", epicNo = " + this.epicNo + ", flip = " + this.flip + ", changeAction = " + this.changeAction.toString() + ", actualValue = " + this.actualValue + "}";
    }

    public static class LogFlinkArrayData
    implements LogArrayData {
        ArrayData arrayData;

        private LogFlinkArrayData(ArrayData arrayData) {
            this.arrayData = arrayData;
        }

        public boolean getBoolean(int pos) {
            return this.arrayData.getBoolean(pos);
        }

        public int getInt(int pos) {
            return this.arrayData.getInt(pos);
        }

        public long getLong(int pos) {
            return this.arrayData.getLong(pos);
        }

        public float getFloat(int pos) {
            return this.arrayData.getFloat(pos);
        }

        public double getDouble(int pos) {
            return this.arrayData.getFloat(pos);
        }

        public LocalDateTime getTimestamp(int pos) {
            return this.arrayData.getTimestamp(pos, 9).toLocalDateTime();
        }

        public Instant getInstant(int pos) {
            return this.arrayData.getTimestamp(pos, 9).toInstant();
        }

        public String getString(int pos) {
            return this.arrayData.getString(pos).toString();
        }

        public byte[] getBinary(int pos) {
            return this.arrayData.getBinary(pos);
        }

        public BigDecimal getDecimal(int pos) {
            return this.arrayData.getDecimal(pos, 38, 18).toBigDecimal();
        }

        public Object getStruct(int pos) {
            return this.arrayData.getRow(pos, 0);
        }

        public LogArrayData getArray(int pos) {
            return new LogFlinkArrayData(this.arrayData.getArray(pos));
        }

        public LogMapData getMap(int pos) {
            return new LogFlinkMapData(this.arrayData.getMap(pos));
        }

        public boolean isNullAt(int pos) {
            return this.arrayData.isNullAt(pos);
        }

        public int size() {
            return this.arrayData.size();
        }
    }

    public static class LogFlinkMapData
    implements LogMapData {
        private final MapData mapData;

        private LogFlinkMapData(MapData mapData) {
            this.mapData = mapData;
        }

        public int size() {
            return this.mapData.size();
        }

        public LogArrayData keyArray() {
            return new LogFlinkArrayData(this.mapData.keyArray());
        }

        public LogArrayData valueArray() {
            return new LogFlinkArrayData(this.mapData.valueArray());
        }
    }
}

