/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.utils;

import com.mzlion.core.exceptions.FileArchiveException;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void pack(String zipPath, File ... files) {
        ZipUtils.pack(zipPath, StandardCharsets.UTF_8, files);
    }

    public static void pack(String zipPath, Charset encoding, File ... files) {
        if (StringUtils.hasLength(zipPath)) {
            ZipUtils.pack(new File(zipPath), encoding, files);
        }
    }

    public static void pack(File zipFile, File ... files) {
        ZipUtils.pack(zipFile, StandardCharsets.UTF_8, files);
    }

    public static void pack(File zipFile, Charset encoding, File ... files) {
        Assert.notNull(zipFile, "ZipFile is null.");
        Assert.notNull(encoding, "Encoding is null.");
        Assert.notEmpty(files, "Files is null or empty.");
        LinkedList<Path> pathList = new LinkedList<Path>();
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            Assert.notNull(files[i], "The index[" + i + "] is null.");
            pathList.add(files[i].toPath());
        }
        Path[] paths = new Path[files.length];
        pathList.toArray(paths);
        ZipUtils.pack(zipFile.toPath(), encoding, paths);
    }

    public static void pack(Path zipPath, Path ... paths) {
        ZipUtils.pack(zipPath, StandardCharsets.UTF_8, paths);
    }

    public static void pack(Path zipPath, Charset encoding, Path ... paths) {
        Assert.notNull(zipPath, "The zipPath is null.");
        Assert.notNull(encoding, "The encoding is null.");
        Assert.notNull(encoding, "The paths is null or empty.");
        ZipUtils.validate(zipPath, paths);
        try (FileOutputStream fos = new FileOutputStream(zipPath.toFile());
             final ZipOutputStream zos = new ZipOutputStream((OutputStream)fos, encoding);){
            for (Path path : paths) {
                final Path parent = path.getParent();
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (Files.size(dir) == 0L) {
                            zos.putNextEntry(new ZipEntry(parent.relativize(dir).toString() + "/"));
                            zos.closeEntry();
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        zos.putNextEntry(new ZipEntry(parent.relativize(file).toString()));
                        Files.copy(file, zos);
                        zos.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            throw new FileArchiveException(e);
        }
    }

    public static void unpack(String zipPath, String toDirPath) {
        ZipUtils.unpack(zipPath, toDirPath, StandardCharsets.UTF_8);
    }

    public static void unpack(String zipPath, String toDirPath, Charset encoding) {
        if (StringUtils.hasLength(zipPath)) {
            ZipUtils.unpack(new File(zipPath), toDirPath, encoding);
        }
    }

    public static void unpack(String zipPath, File toDirFile) {
        ZipUtils.unpack(zipPath, toDirFile, StandardCharsets.UTF_8);
    }

    public static void unpack(String zipPath, File toDirFile, Charset encoding) {
        if (StringUtils.hasLength(zipPath)) {
            ZipUtils.unpack(new File(zipPath), toDirFile, encoding);
        }
    }

    public static void unpack(File zipFile, File toDirFile) {
        ZipUtils.unpack(zipFile, toDirFile, StandardCharsets.UTF_8);
    }

    public static void unpack(File zipFile, String toDirPath) {
        ZipUtils.unpack(zipFile, toDirPath, StandardCharsets.UTF_8);
    }

    public static void unpack(File zipFile, String toDirPath, Charset encoding) {
        if (StringUtils.isEmpty(toDirPath)) {
            ZipUtils.unpack(zipFile, new File(toDirPath), encoding);
        }
    }

    public static void unpack(File zipFile, File toDirFile, Charset encoding) {
        Assert.notNull(zipFile, "The zipFile is null.");
        Assert.notNull(encoding, "The encoding is null.");
        Assert.notNull(toDirFile, "The toDirFile is null.");
        ZipUtils.unpack(zipFile.toPath(), toDirFile.toPath(), encoding);
    }

    public static void unpack(Path zipPath, Path toDirPath) {
        ZipUtils.unpack(zipPath, toDirPath, StandardCharsets.UTF_8);
    }

    public static void unpack(Path zipPath, Path toDirPath, Charset encoding) {
        Assert.notNull(zipPath, "The zipPath is null.");
        Assert.notNull(encoding, "The encoding is null.");
        Assert.notNull(toDirPath, "The toDirPath is null.");
        if (!StringUtils.endsWithIgnoreCase(zipPath.getFileName().toString(), "zip")) {
            throw new FileArchiveException("The zipFile is not a zip file.");
        }
        if (!zipPath.toFile().exists()) {
            throw new FileArchiveException("The zipFile does't exist.");
        }
        if (toDirPath.toFile().exists() && !toDirPath.toFile().isDirectory()) {
            throw new FileArchiveException("The toDirPath is not a directory.");
        }
        FileSystemProvider provider = ZipUtils.getZipFS();
        HashMap env = new HashMap();
        try (FileSystem fs = provider.newFileSystem(zipPath, env);){
            ZipUtils.extract(fs, toDirPath.toString(), null);
        }
        catch (IOException e) {
            throw new FileArchiveException(e);
        }
    }

    public static void unpackx(Path zipPath, String dir) {
        FileSystemProvider provider = ZipUtils.getZipFS();
        HashMap env = new HashMap();
        try (FileSystem fs = provider.newFileSystem(zipPath, env);){
            ZipUtils.extract(fs, "/", Paths.get(dir, new String[0]));
        }
        catch (IOException e) {
            throw new FileArchiveException(e);
        }
    }

    private static void extract(FileSystem fs, String path, Path destPath) throws IOException {
        Path src = fs.getPath(path, new String[0]);
        if (Files.isDirectory(src, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(src);){
                for (Path child : ds) {
                    ZipUtils.extract(fs, child.toString(), destPath);
                }
            }
        } else {
            Path dst;
            Path parent;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (Files.notExists(parent = (dst = destPath.resolve(path)).getParent(), new LinkOption[0])) {
                ZipUtils.mkdirs(parent);
            }
            Files.copy(src, dst, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void mkdirs(Path path) throws IOException {
        Path parent = (path = path.toAbsolutePath()).getParent();
        if (parent != null && Files.notExists(parent, new LinkOption[0])) {
            ZipUtils.mkdirs(parent);
        }
        Files.createDirectory(path, new FileAttribute[0]);
    }

    private static void validate(Path zipPath, Path ... paths) {
        if (zipPath.toFile().isDirectory()) {
            throw new FileArchiveException("The zipPath is a directory.");
        }
        Path zipParent = zipPath.getParent();
        for (Path path : paths) {
            if (!path.toFile().exists()) {
                throw new FileArchiveException("The path[" + path.toString() + "] does not exist.");
            }
            if (path.toFile().isDirectory()) {
                if (!zipParent.startsWith(path)) continue;
                throw new FileArchiveException(String.format("Destination [%s] is child directory of source [%s].", zipParent, path));
            }
            if (!zipParent.startsWith(path.getParent())) continue;
            throw new FileArchiveException(String.format("Destination [%s] is child directory of source [%s].", zipParent, path.getParent()));
        }
    }

    public static FileSystemProvider getZipFS() {
        for (FileSystemProvider fileSystemProvider : FileSystemProvider.installedProviders()) {
            if (!"jar".equals(fileSystemProvider.getScheme())) continue;
            return fileSystemProvider;
        }
        throw new FileArchiveException("ZIP filesystem provider is not installed");
    }
}

