/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.io.resource;

import com.mzlion.core.io.FilenameUtils;
import com.mzlion.core.io.resource.AbstractResourceDescriptor;
import com.mzlion.core.lang.StringUtils;
import com.mzlion.core.utils.ClassLoaderUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ClassPathResourceDescriptor
extends AbstractResourceDescriptor {
    private final String path;
    private ClassLoader classLoader;
    private Class<?> clazz;

    public ClassPathResourceDescriptor(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResourceDescriptor(String path, ClassLoader classLoader) {
        if (StringUtils.isEmpty(path)) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        this.path = path;
        this.classLoader = classLoader == null ? ClassLoaderUtils.getDefaultClassLoader() : classLoader;
    }

    public ClassPathResourceDescriptor(String path, Class<?> clazz) {
        if (StringUtils.isEmpty(path)) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        this.path = path;
        this.clazz = clazz;
    }

    public ClassPathResourceDescriptor(String path, ClassLoader classLoader, Class<?> clazz) {
        if (StringUtils.isEmpty(path)) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        this.path = path;
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean exists() {
        URL url = this.clazz != null ? this.clazz.getResource(this.path) : this.classLoader.getResource(this.path);
        return url != null;
    }

    @Override
    public InputStream getInputStream() {
        InputStream in = this.clazz != null ? this.clazz.getResourceAsStream(this.path) : this.classLoader.getResourceAsStream(this.path);
        return in;
    }

    @Override
    public URL getURL() throws IOException {
        URL url = this.clazz != null ? this.clazz.getResource(this.path) : this.classLoader.getResource(this.path);
        return url;
    }

    @Override
    public String getFilename() {
        return FilenameUtils.getFilename(this.path);
    }

    @Override
    public File getFile() throws IOException {
        URL url = this.getURL();
        return new File(url.getFile());
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder("class path resource [");
        String pathToUse = this.path;
        if (this.clazz != null && !pathToUse.startsWith("/")) {
            builder.append('/');
        }
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        builder.append(pathToUse);
        builder.append(']');
        return builder.toString();
    }
}

