/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.request;

import com.mzlion.core.http.ContentType;
import com.mzlion.core.io.IOUtils;
import com.mzlion.core.lang.Assert;
import com.mzlion.easyokhttp.request.BaseBodyHttpRequest;
import com.mzlion.easyokhttp.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class BinaryBodyPostRequest
extends BaseBodyHttpRequest<BinaryBodyPostRequest> {
    private byte[] content;
    private MediaType mediaType;

    public BinaryBodyPostRequest(String url) {
        super(url);
    }

    public BinaryBodyPostRequest stream(InputStream inputStream) {
        Assert.notNull((Object)inputStream, (String)"In must not be null.");
        Assert.notNull((Object)this.mediaType, (String)"MediaType must not be null.");
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            if (IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream) == -1) {
                throw new IOException("Copy failed");
            }
            this.content = outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Reading stream failed->", e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
        return this;
    }

    public BinaryBodyPostRequest file(File file) {
        Assert.notNull((Object)file, (String)"File must not be null.");
        String filename = file.getName();
        MediaType mediaType = Utils.guessMediaType(filename);
        try {
            this.stream(new FileInputStream(file));
            this.mediaType = mediaType;
            return this;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public BinaryBodyPostRequest contentType(String contentType) {
        Assert.hasLength((String)contentType, (String)"ContentType must not be null.");
        this.mediaType = MediaType.parse((String)contentType);
        return this;
    }

    public BinaryBodyPostRequest contentType(ContentType contentType) {
        Assert.notNull((Object)contentType, (String)"ContentType must not be null.");
        this.mediaType = MediaType.parse((String)contentType.toString());
        return this;
    }

    @Override
    protected RequestBody generateRequestBody() {
        return RequestBody.create((MediaType)this.mediaType, (byte[])this.content);
    }
}

