/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.http;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DebugLoggingInterceptor implements Interceptor
{
    INSTANCE;

    private final Logger logger = LoggerFactory.getLogger(DebugLoggingInterceptor.class);
    private Level loggingLevel = Level.NONE;

    public void setLoggingLevel(Level loggingLevel) {
        this.loggingLevel = loggingLevel == null ? Level.NONE : loggingLevel;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.loggingRequest(request);
        long startTime = System.nanoTime();
        Response response = chain.proceed(request);
        long usedTimes = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        this.loggingResponse(response, usedTimes);
        return response;
    }

    private void loggingResponse(Response response, long usedTimes) throws IOException {
        if (this.loggingLevel == Level.NONE || this.loggingLevel == Level.REQUEST) {
            return;
        }
        boolean bodyPrint = this.loggingLevel == Level.RESPONSE || this.loggingLevel == Level.BASIC || this.loggingLevel == Level.ALL;
        boolean headerPrint = this.loggingLevel == Level.RESPONSE || this.loggingLevel == Level.HEADER || this.loggingLevel == Level.ALL;
        HttpUrl httpUrl = response.request().url();
        ResponseBody responseBody = response.peekBody(2048L);
        if (this.loggingLevel == Level.RESPONSE) {
            this.logger.info(" |=== Start to print the connection[{}] data ===|", (Object)httpUrl.toString());
        }
        this.logger.info(" |=== The request executes over,http statusCode is {},http message is {},taking {} ms", new Object[]{response.code(), response.message(), usedTimes});
        if (headerPrint) {
            this.logger.info(" |=== Start to print response headers === |");
            Headers headers = response.headers();
            for (String name : headers.names()) {
                this.logger.info(" |=== {} : {} ===|", (Object)name, (Object)headers.get(name));
            }
            this.logger.info(" |=== Finish to print response headers === |");
        }
        if (bodyPrint && HttpHeaders.hasBody((Response)response)) {
            if (this.isPlainText(responseBody.contentType())) {
                this.logger.info(" |=== Start to print response body === |");
                this.logger.info(" |=== The body data is \n{}", (Object)responseBody.string());
                this.logger.info(" |=== Finish to print response body === |");
            } else {
                this.logger.warn(" |=== The response body may contains 'file' part, ignore to print! ===|");
            }
        }
        this.logger.info(" |=== Finish to print the connection[{}] data ===|\n", (Object)httpUrl.toString());
    }

    private void loggingRequest(Request request) throws IOException {
        RequestBody requestBody;
        if (this.loggingLevel == Level.NONE || this.loggingLevel == Level.RESPONSE) {
            return;
        }
        boolean bodyPrint = this.loggingLevel == Level.REQUEST || this.loggingLevel == Level.BASIC || this.loggingLevel == Level.ALL;
        boolean headerPrint = this.loggingLevel == Level.REQUEST || this.loggingLevel == Level.HEADER || this.loggingLevel == Level.ALL;
        HttpUrl httpUrl = request.url();
        this.logger.info(" |=== Start to print the connection[{}] data ===|", (Object)httpUrl.toString());
        if (headerPrint) {
            this.logger.info(" |=== Start to print request headers === |");
            Headers headers = request.headers();
            for (String name : headers.names()) {
                this.logger.info(" |=== {} : {} ===|", (Object)name, (Object)headers.get(name));
            }
            this.logger.info(" |=== Finish to print request headers === |");
        }
        if (bodyPrint && (requestBody = request.body()) != null) {
            if (this.isPlainText(requestBody.contentType())) {
                this.logger.info(" |=== Start to print request body === |");
                Request copy = request.newBuilder().build();
                requestBody = copy.body();
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                MediaType mediaType = requestBody.contentType();
                this.logger.info(" |=== The body data is {} ===|", (Object)buffer.readString(mediaType.charset(Util.UTF_8)));
                this.logger.info(" |=== Finish to print request body === |");
            } else {
                this.logger.warn(" |=== The request body may contains 'file' part, ignore to print! ===|");
            }
        }
        if (this.loggingLevel == Level.REQUEST) {
            this.logger.info(" |=== Finish to print the connection[{}] data ===|\n", (Object)httpUrl.toString());
        }
    }

    private boolean isPlainText(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        if (mediaType.type() != null && mediaType.type().equals("text")) {
            return true;
        }
        String subtype = mediaType.subtype();
        return subtype != null && (subtype.contains("x-www-form-urlencoded") || subtype.contains("json") || subtype.contains("xml") || subtype.contains("html"));
    }

    public static enum Level {
        NONE,
        BASIC,
        HEADER,
        REQUEST,
        RESPONSE,
        ALL;

    }
}

