/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.service.impl;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.service.IService;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ClassUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class CacheableServiceImpl<M extends BaseMapper<T>, T>
implements IService<T> {
    @Autowired
    private M mapper;

    public BaseMapper<T> getMapper() {
        return this.mapper;
    }

    public boolean saveOrUpdate(T entity) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entity.getClass());
        Object[] pkArgs = tableInfo.buildPkSqlArgs(entity);
        if (pkArgs.length == 0 || pkArgs[0] == null) {
            return this.save(entity);
        }
        return this.updateById(entity);
    }

    public QueryWrapper query() {
        Class mapperClass = ClassUtil.getUsefulClass(this.getMapper().getClass());
        TableInfo tableInfo = TableInfoFactory.ofMapperClass((Class)mapperClass);
        return QueryWrapper.create().from(new QueryTable[]{new QueryTable(tableInfo.getSchema(), tableInfo.getTableName())});
    }
}

