/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.Arrays;
import java.util.List;

public class StringFunctionQueryColumn
extends QueryColumn {
    protected String fnName;
    protected List<String> params;

    public StringFunctionQueryColumn(String fnName, String ... params) {
        SqlUtil.keepColumnSafely(fnName);
        this.fnName = fnName;
        this.params = Arrays.asList(params);
    }

    public String getFnName() {
        return this.fnName;
    }

    public void setFnName(String fnName) {
        this.fnName = fnName;
    }

    public List<String> getParams() {
        return this.params;
    }

    public void setParams(List<String> params) {
        this.params = params;
    }

    @Override
    public String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        String sql = StringUtil.join(", ", this.params);
        if (StringUtil.isBlank(sql)) {
            return "";
        }
        if (StringUtil.isBlank(this.alias)) {
            return this.fnName + WrapperUtil.withBracket(sql);
        }
        return this.fnName + WrapperUtil.withAlias(sql, dialect.wrap(this.alias), dialect);
    }

    @Override
    String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        String sql = StringUtil.join(", ", this.params);
        if (StringUtil.isBlank(sql)) {
            return "";
        }
        return this.fnName + WrapperUtil.withBracket(sql);
    }

    @Override
    public QueryColumn as(String alias) {
        SqlUtil.keepColumnSafely(alias);
        this.alias = alias;
        return this;
    }

    @Override
    public String toString() {
        return "StringFunctionQueryColumn{fnName='" + this.fnName + '\'' + ", params=" + this.params + '}';
    }

    @Override
    public StringFunctionQueryColumn clone() {
        StringFunctionQueryColumn clone = (StringFunctionQueryColumn)super.clone();
        clone.params = CollectionUtil.newArrayList(this.params);
        return clone;
    }
}

