/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.dialect.impl.OracleDialect;
import com.mybatisflex.core.query.Brackets;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.OperatorSelectCondition;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.RawQueryCondition;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.EnumWrapper;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class WrapperUtil {
    private WrapperUtil() {
    }

    static List<QueryWrapper> getChildQueryWrapper(QueryCondition condition) {
        ArrayList<QueryWrapper> list = null;
        while (condition != null) {
            if (condition.checkEffective()) {
                if (condition instanceof Brackets) {
                    List<QueryWrapper> childQueryWrapper = WrapperUtil.getChildQueryWrapper(((Brackets)condition).getChildCondition());
                    if (!childQueryWrapper.isEmpty()) {
                        if (list == null) {
                            list = new ArrayList();
                        }
                        list.addAll(childQueryWrapper);
                    }
                } else if (condition instanceof OperatorSelectCondition) {
                    if (list == null) {
                        list = new ArrayList<QueryWrapper>();
                    }
                    list.add(((OperatorSelectCondition)condition).getQueryWrapper());
                } else {
                    Object value = condition.getValue();
                    if (value instanceof QueryWrapper) {
                        if (list == null) {
                            list = new ArrayList();
                        }
                        list.add((QueryWrapper)value);
                        list.addAll(((QueryWrapper)value).getChildSelect());
                    } else if (value != null && value.getClass().isArray()) {
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            Object arrayValue = Array.get(value, i);
                            if (!(arrayValue instanceof QueryWrapper)) continue;
                            if (list == null) {
                                list = new ArrayList();
                            }
                            list.add((QueryWrapper)arrayValue);
                            list.addAll(((QueryWrapper)arrayValue).getChildSelect());
                        }
                    }
                }
            }
            condition = condition.next;
        }
        return list == null ? Collections.emptyList() : list;
    }

    static Object[] getValues(QueryCondition condition) {
        if (condition == null) {
            return FlexConsts.EMPTY_ARRAY;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        WrapperUtil.getValues(condition, params);
        return params.isEmpty() ? FlexConsts.EMPTY_ARRAY : params.toArray();
    }

    private static void getValues(QueryCondition condition, List<Object> params) {
        Object value;
        if (condition == null) {
            return;
        }
        QueryColumn column = condition.getColumn();
        if (column instanceof HasParamsColumn) {
            WrapperUtil.addParam(params, ((HasParamsColumn)((Object)column)).getParamValues());
        }
        if ((value = condition.getValue()) == null) {
            String logic;
            if (condition.checkEffective() && (logic = condition.getLogic()) != null && !logic.equals(" IS NULL ") && !logic.equals(" IS NOT NULL ")) {
                params.add(null);
            }
            WrapperUtil.getValues(condition.next, params);
            return;
        }
        if (value instanceof QueryColumn || value instanceof RawQueryCondition) {
            WrapperUtil.getValues(condition.next, params);
            return;
        }
        WrapperUtil.addParam(params, value);
        WrapperUtil.getValues(condition.next, params);
    }

    private static void addParam(List<Object> paras, Object value) {
        if (value == null) {
            paras.add(null);
        } else if (ClassUtil.isArray(value.getClass())) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                WrapperUtil.addParam(paras, Array.get(value, i));
            }
        } else if (value instanceof QueryWrapper) {
            Object[] valueArray = ((QueryWrapper)value).getAllValueArray();
            paras.addAll(Arrays.asList(valueArray));
        } else if (value instanceof Enum) {
            EnumWrapper enumWrapper = EnumWrapper.of(value.getClass());
            value = enumWrapper.hasEnumValueAnnotation() ? enumWrapper.getEnumValue((Enum)value) : value;
            paras.add(value);
        } else {
            paras.add(value);
        }
    }

    static String buildValue(List<QueryTable> queryTables, Object value) {
        if (value instanceof Number || value instanceof Boolean) {
            return String.valueOf(value);
        }
        if (value instanceof RawQueryCondition) {
            return ((RawQueryCondition)value).getContent();
        }
        if (value instanceof QueryColumn) {
            return ((QueryColumn)value).toConditionSql(queryTables, DialectFactory.getDialect());
        }
        return "'" + value + "'";
    }

    static String withBracket(String sql) {
        return "(" + sql + ")";
    }

    static String withAlias(String sql, String alias, IDialect dialect) {
        return "(" + sql + ")" + WrapperUtil.buildColumnAlias(alias, dialect);
    }

    static String buildAlias(String alias, IDialect dialect) {
        return StringUtil.noText(alias) ? "" : WrapperUtil.getAsKeyWord(dialect) + dialect.wrap(alias);
    }

    static String buildColumnAlias(String alias, IDialect dialect) {
        return StringUtil.noText(alias) ? "" : WrapperUtil.getAsKeyWord(dialect) + dialect.wrapColumnAlias(alias);
    }

    private static String getAsKeyWord(IDialect dialect) {
        return dialect instanceof OracleDialect ? " " : " AS ";
    }
}

