/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import com.microsoft.rest.serializer.JacksonAdapter;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public abstract class ServiceClient {
    private RestClient restClient;

    protected ServiceClient(String baseUrl) {
        this(baseUrl, new OkHttpClient.Builder(), new Retrofit.Builder());
    }

    protected ServiceClient(String baseUrl, OkHttpClient.Builder clientBuilder, Retrofit.Builder restBuilder) {
        this(new RestClient.Builder(clientBuilder, restBuilder).withBaseUrl(baseUrl).withResponseBuilderFactory(new ServiceResponseBuilder.Factory()).withSerializerAdapter(new JacksonAdapter()).build());
    }

    protected ServiceClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public RestClient restClient() {
        return this.restClient;
    }

    public Retrofit retrofit() {
        return this.restClient.retrofit();
    }

    public OkHttpClient httpClient() {
        return this.restClient.httpClient();
    }

    public SerializerAdapter<?> serializerAdapter() {
        return this.restClient.serializerAdapter();
    }
}

