/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.GenericResource;
import com.microsoft.azure.management.resources.GenericResources;
import com.microsoft.azure.management.resources.Provider;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.ResourcesMoveInfo;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.resources.implementation.GenericResourceExpandedInner;
import com.microsoft.azure.management.resources.implementation.GenericResourceImpl;
import com.microsoft.azure.management.resources.implementation.GenericResourceInner;
import com.microsoft.azure.management.resources.implementation.ResourceManager;
import com.microsoft.azure.management.resources.implementation.ResourcesInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

final class GenericResourcesImpl
extends GroupableResourcesImpl<GenericResource, GenericResourceImpl, GenericResourceInner, ResourcesInner, ResourceManager>
implements GenericResources {
    private PagedListConverter<GenericResourceExpandedInner, GenericResource> converter = new PagedListConverter<GenericResourceExpandedInner, GenericResource>(){

        @Override
        public Observable<GenericResource> typeConvertAsync(GenericResourceExpandedInner inner) {
            return Observable.just((Object)new GenericResourceImpl(inner.name(), inner, (ResourceManager)GenericResourcesImpl.this.manager()));
        }
    };

    GenericResourcesImpl(ResourceManager resourceManager) {
        super(resourceManager.inner().resources(), resourceManager);
    }

    @Override
    public PagedList<GenericResource> list() {
        return this.converter.convert(((ResourcesInner)this.inner()).list());
    }

    @Override
    public PagedList<GenericResource> listByResourceGroup(String groupName) {
        return this.converter.convert(((ResourceManager)this.manager()).inner().resources().listByResourceGroup(groupName));
    }

    @Override
    public PagedList<GenericResource> listByTag(String resourceGroupName, String tagName, String tagValue) {
        return this.converter.convert(((ResourceManager)this.manager()).inner().resources().listByResourceGroup(resourceGroupName, Utils.createOdataFilterForTags(tagName, tagValue), null, null));
    }

    @Override
    public Observable<GenericResource> listByTagAsync(String resourceGroupName, String tagName, String tagValue) {
        return this.convert(((ResourceManager)this.manager()).inner().resources().listByResourceGroupAsync(resourceGroupName, Utils.createOdataFilterForTags(tagName, tagValue), null, null));
    }

    @Override
    public GenericResource.DefinitionStages.Blank define(String name) {
        return new GenericResourceImpl(name, new GenericResourceInner(), (ResourceManager)this.manager());
    }

    @Override
    public boolean checkExistence(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return ((ResourcesInner)this.inner()).checkExistence(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion);
    }

    @Override
    public boolean checkExistenceById(String id) {
        String apiVersion = (String)this.getApiVersionFromIdAsync(id).toBlocking().single();
        return this.checkExistenceById(id, apiVersion);
    }

    @Override
    public boolean checkExistenceById(String id, String apiVersion) {
        return ((ResourcesInner)this.inner()).checkExistenceById(id, apiVersion);
    }

    @Override
    public Observable<GenericResource> getByIdAsync(final String id) {
        final GenericResourcesImpl self = this;
        return this.getApiVersionFromIdAsync(id).flatMap((Func1)new Func1<String, Observable<GenericResource>>(){

            public Observable<GenericResource> call(String s) {
                return self.getByIdAsync(id, s);
            }
        });
    }

    @Override
    public Completable deleteByIdAsync(final String id) {
        final ResourcesInner inner = (ResourcesInner)this.inner();
        return this.getApiVersionFromIdAsync(id).flatMap((Func1)new Func1<String, Observable<Void>>(){

            public Observable<Void> call(String apiVersion) {
                return inner.deleteByIdAsync(id, apiVersion);
            }
        }).toCompletable();
    }

    @Override
    public void deleteById(String id, String apiVersion) {
        this.deleteByIdAsync(id, apiVersion).await();
    }

    @Override
    public Completable deleteByIdAsync(String id, String apiVersion) {
        return ((ResourcesInner)this.inner()).deleteByIdAsync(id, apiVersion).toCompletable();
    }

    @Override
    public GenericResource getById(String id, String apiVersion) {
        return (GenericResource)this.getByIdAsync(id, apiVersion).toBlocking().last();
    }

    @Override
    public Observable<GenericResource> getByIdAsync(String id, final String apiVersion) {
        return ((ResourcesInner)this.inner()).getByIdAsync(id, apiVersion).map((Func1)new Func1<GenericResourceInner, GenericResource>(){

            public GenericResource call(GenericResourceInner genericResourceInner) {
                GenericResourceImpl genericResource = GenericResourcesImpl.this.wrapModel(genericResourceInner);
                if (genericResource != null) {
                    genericResource.withApiVersion(apiVersion);
                }
                return genericResource;
            }
        });
    }

    @Override
    public GenericResource get(String resourceGroupName, String providerNamespace, String resourceType, String name) {
        PagedList<GenericResource> genericResources = this.listByResourceGroup(resourceGroupName);
        for (GenericResource resource : genericResources) {
            if (!resource.name().equalsIgnoreCase(name) || !resource.resourceProviderNamespace().equalsIgnoreCase(providerNamespace) || !resource.resourceType().equalsIgnoreCase(resourceType)) continue;
            return resource;
        }
        return null;
    }

    @Override
    public GenericResource get(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        GenericResourceInner inner;
        if (parentResourcePath == null) {
            parentResourcePath = "";
        }
        if ((inner = ((ResourcesInner)this.inner()).get(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion)) == null) {
            return null;
        }
        GenericResourceImpl resource = new GenericResourceImpl(resourceName, inner, (ResourceManager)this.manager());
        return ((GenericResourceImpl)resource.withExistingResourceGroup(resourceGroupName)).withProviderNamespace(resourceProviderNamespace).withParentResourcePath(parentResourcePath).withResourceType(resourceType).withApiVersion(apiVersion);
    }

    @Override
    public void moveResources(String sourceResourceGroupName, ResourceGroup targetResourceGroup, List<String> resources) {
        this.moveResourcesAsync(sourceResourceGroupName, targetResourceGroup, resources).await();
    }

    @Override
    public Completable moveResourcesAsync(String sourceResourceGroupName, ResourceGroup targetResourceGroup, List<String> resources) {
        ResourcesMoveInfo moveInfo = new ResourcesMoveInfo();
        moveInfo.withTargetResourceGroup(targetResourceGroup.id());
        moveInfo.withResources(resources);
        return ((ResourcesInner)this.inner()).moveResourcesAsync(sourceResourceGroupName, moveInfo).toCompletable();
    }

    @Override
    public ServiceFuture<Void> moveResourcesAsync(String sourceResourceGroupName, ResourceGroup targetResourceGroup, List<String> resources, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.moveResourcesAsync(sourceResourceGroupName, targetResourceGroup, resources), callback);
    }

    @Override
    public void delete(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        this.deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).await();
    }

    @Override
    public Completable deleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return ((ResourcesInner)this.inner()).deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).toCompletable();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion), callback);
    }

    @Override
    public void delete(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, boolean forceDeletion) {
        this.deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, forceDeletion).await();
    }

    @Override
    public Completable deleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, boolean forceDeletion) {
        return ((ResourcesInner)this.inner()).deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, forceDeletion).toCompletable().subscribeOn(SdkContext.getRxScheduler());
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, boolean forceDeletion, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, forceDeletion), callback);
    }

    @Override
    protected GenericResourceImpl wrapModel(String id) {
        return ((GenericResourceImpl)new GenericResourceImpl(id, new GenericResourceInner(), (ResourceManager)this.manager()).withExistingResourceGroup(ResourceUtils.groupFromResourceId(id))).withProviderNamespace(ResourceUtils.resourceProviderFromResourceId(id)).withResourceType(ResourceUtils.resourceTypeFromResourceId(id)).withParentResourceId(ResourceUtils.parentResourceIdFromResourceId(id));
    }

    @Override
    protected GenericResourceImpl wrapModel(GenericResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return ((GenericResourceImpl)new GenericResourceImpl(inner.id(), inner, (ResourceManager)this.manager()).withExistingResourceGroup(ResourceUtils.groupFromResourceId(inner.id()))).withProviderNamespace(ResourceUtils.resourceProviderFromResourceId(inner.id())).withResourceType(ResourceUtils.resourceTypeFromResourceId(inner.id())).withParentResourceId(ResourceUtils.parentResourceIdFromResourceId(inner.id()));
    }

    @Override
    public Observable<GenericResourceInner> getInnerAsync(String groupName, String name) {
        throw new UnsupportedOperationException("Get just by resource group and name is not supported. Please use other overloads.");
    }

    @Override
    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        throw new UnsupportedOperationException("Delete just by resource group and name is not supported. Please use other overloads.");
    }

    private Observable<String> getApiVersionFromIdAsync(final String id) {
        return ((ResourceManager)this.manager()).providers().getByNameAsync(ResourceUtils.resourceProviderFromResourceId(id)).map((Func1)new Func1<Provider, String>(){

            public String call(Provider provider) {
                return ResourceUtils.defaultApiVersion(id, provider);
            }
        });
    }

    @Override
    public Observable<GenericResource> listAsync() {
        return this.convert(((ResourcesInner)this.inner()).listAsync());
    }

    @Override
    public Observable<GenericResource> listByResourceGroupAsync(String resourceGroupName) {
        return this.convert(((ResourceManager)this.manager()).inner().resources().listByResourceGroupAsync(resourceGroupName));
    }

    private Observable<GenericResource> convert(Observable<Page<GenericResourceExpandedInner>> inners) {
        return inners.flatMap((Func1)new Func1<Page<GenericResourceExpandedInner>, Observable<GenericResourceExpandedInner>>(){

            public Observable<GenericResourceExpandedInner> call(Page<GenericResourceExpandedInner> genericResourceExpandedInnerPage) {
                return Observable.from((Iterable)genericResourceExpandedInnerPage.items());
            }
        }).map((Func1)new Func1<GenericResourceExpandedInner, GenericResource>(){

            public GenericResource call(GenericResourceExpandedInner inner) {
                return GenericResourcesImpl.this.wrapModel(inner);
            }
        });
    }
}

