/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_PUBLIC;

public class TSS_KEY
extends TpmStructure {
    public TPMT_PUBLIC publicPart;
    public byte[] privatePart;

    public TSS_KEY() {
    }

    public TSS_KEY(TPMT_PUBLIC _publicPart, byte[] _privatePart) {
        this.publicPart = _publicPart;
        this.privatePart = _privatePart;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.publicPart.toTpm(buf);
        buf.writeSizedByteBuf(this.privatePart);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.publicPart = TPMT_PUBLIC.fromTpm(buf);
        this.privatePart = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TSS_KEY fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TSS_KEY.class);
    }

    public static TSS_KEY fromTpm(byte[] byteBuf) {
        return TSS_KEY.fromBytes(byteBuf);
    }

    public static TSS_KEY fromTpm(TpmBuffer buf) {
        return buf.createObj(TSS_KEY.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TSS_KEY");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMT_PUBLIC", "publicPart", this.publicPart);
        _p.add(d, "byte[]", "privatePart", this.privatePart);
    }
}

