/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.Helpers;
import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HT;
import tss.tpm.TPM_RH;

public class TPM_HANDLE
extends TpmStructure {
    public int handle;
    public static final TPM_HANDLE NULL = TPM_HANDLE.from(TPM_RH.NULL);
    public static final TPM_HANDLE PW = TPM_HANDLE.from(TPM_RH.PW);
    public static final TPM_HANDLE OWNER = TPM_HANDLE.from(TPM_RH.OWNER);
    public static final TPM_HANDLE ENDORSEMENT = TPM_HANDLE.from(TPM_RH.ENDORSEMENT);
    public static final TPM_HANDLE PLATFORM = TPM_HANDLE.from(TPM_RH.PLATFORM);
    public byte[] AuthValue;
    public byte[] Name;

    public TPM_HANDLE() {
        this.handle = TPM_RH.NULL.toInt();
    }

    public TPM_HANDLE(int _handle) {
        this.handle = _handle;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeInt(this.handle);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.handle = buf.readInt();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM_HANDLE fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM_HANDLE.class);
    }

    public static TPM_HANDLE fromTpm(byte[] byteBuf) {
        return TPM_HANDLE.fromBytes(byteBuf);
    }

    public static TPM_HANDLE fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM_HANDLE.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM_HANDLE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "int", "handle", this.handle);
    }

    public static TPM_HANDLE from(int val) {
        return new TPM_HANDLE(val);
    }

    public static TPM_HANDLE from(TPM_RH _handle) {
        return new TPM_HANDLE(_handle.toInt());
    }

    public static TPM_HANDLE nullHandle() {
        return new TPM_HANDLE(TPM_RH.NULL.toInt());
    }

    public static TPM_HANDLE persistent(int handleOffset) {
        return new TPM_HANDLE((TPM_HT.PERSISTENT.toInt() << 24) + handleOffset);
    }

    public static TPM_HANDLE pcr(int PcrIndex) {
        return new TPM_HANDLE(PcrIndex);
    }

    public static TPM_HANDLE NV(int NvSlot) {
        int handleVal = (TPM_HT.NV_INDEX.toInt() << 24) + NvSlot;
        return new TPM_HANDLE(handleVal);
    }

    public TPM_HT getType() {
        return TPM_HT.fromInt(this.handle >> 24);
    }

    public static TPM_HANDLE pwSession(byte[] authValue) {
        TPM_HANDLE pwapHandle = TPM_HANDLE.from(TPM_RH.PW);
        pwapHandle.AuthValue = authValue;
        return pwapHandle;
    }

    public byte[] getName() {
        int handleType = this.getType().toInt();
        switch (handleType) {
            case 0: 
            case 2: 
            case 3: 
            case 64: {
                this.Name = Helpers.hostToNet(this.handle);
                return this.Name;
            }
            case 1: 
            case 128: 
            case 129: {
                if (this.Name.length == 0) {
                    throw new RuntimeException("Name is not set for handle");
                }
                return this.Name;
            }
        }
        throw new RuntimeException("Unknown handle type");
    }
}

