/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_ST;

public class TPMT_TK_AUTH
extends TpmStructure {
    public TPM_ST tag;
    public TPM_HANDLE hierarchy;
    public byte[] digest;

    public TPMT_TK_AUTH() {
        this.hierarchy = new TPM_HANDLE();
    }

    public TPMT_TK_AUTH(TPM_ST _tag, TPM_HANDLE _hierarchy, byte[] _digest) {
        this.tag = _tag;
        this.hierarchy = _hierarchy;
        this.digest = _digest;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.tag.toTpm(buf);
        this.hierarchy.toTpm(buf);
        buf.writeSizedByteBuf(this.digest);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.tag = TPM_ST.fromTpm(buf);
        this.hierarchy = TPM_HANDLE.fromTpm(buf);
        this.digest = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMT_TK_AUTH fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMT_TK_AUTH.class);
    }

    public static TPMT_TK_AUTH fromTpm(byte[] byteBuf) {
        return TPMT_TK_AUTH.fromBytes(byteBuf);
    }

    public static TPMT_TK_AUTH fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMT_TK_AUTH.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_TK_AUTH");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ST", "tag", this.tag);
        _p.add(d, "TPM_HANDLE", "hierarchy", this.hierarchy);
        _p.add(d, "byte[]", "digest", this.digest);
    }
}

