/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;

public class TPMT_SYM_DEF
extends TpmStructure {
    public TPM_ALG_ID algorithm;
    public int keyBits;
    public TPM_ALG_ID mode;

    public TPMT_SYM_DEF() {
        this.algorithm = TPM_ALG_ID.NULL;
        this.mode = TPM_ALG_ID.NULL;
    }

    public TPMT_SYM_DEF(TPM_ALG_ID _algorithm, int _keyBits, TPM_ALG_ID _mode) {
        this.algorithm = _algorithm;
        this.keyBits = _keyBits;
        this.mode = _mode;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.algorithm.toTpm(buf);
        if (this.algorithm == TPM_ALG_ID.NULL) {
            return;
        }
        buf.writeShort(this.keyBits);
        this.mode.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.algorithm = TPM_ALG_ID.fromTpm(buf);
        if (this.algorithm == TPM_ALG_ID.NULL) {
            return;
        }
        this.keyBits = buf.readShort();
        this.mode = TPM_ALG_ID.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMT_SYM_DEF fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMT_SYM_DEF.class);
    }

    public static TPMT_SYM_DEF fromTpm(byte[] byteBuf) {
        return TPMT_SYM_DEF.fromBytes(byteBuf);
    }

    public static TPMT_SYM_DEF fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMT_SYM_DEF.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_SYM_DEF");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "algorithm", this.algorithm);
        _p.add(d, "int", "keyBits", this.keyBits);
        _p.add(d, "TPM_ALG_ID", "mode", this.mode);
    }

    @Deprecated
    public static TPMT_SYM_DEF nullObject() {
        return new TPMT_SYM_DEF();
    }
}

