/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.UnionFactory;

public class TPMT_SIGNATURE
extends TpmStructure {
    public TPMU_SIGNATURE signature;

    public TPM_ALG_ID sigAlg() {
        return this.signature != null ? this.signature.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPMT_SIGNATURE() {
    }

    public TPMT_SIGNATURE(TPMU_SIGNATURE _signature) {
        this.signature = _signature;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        if (this.signature == null) {
            return;
        }
        buf.writeShort(this.signature.GetUnionSelector());
        this.signature.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        TPM_ALG_ID sigAlg = TPM_ALG_ID.fromTpm(buf);
        this.signature = (TPMU_SIGNATURE)UnionFactory.create("TPMU_SIGNATURE", sigAlg);
        this.signature.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMT_SIGNATURE fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMT_SIGNATURE.class);
    }

    public static TPMT_SIGNATURE fromTpm(byte[] byteBuf) {
        return TPMT_SIGNATURE.fromBytes(byteBuf);
    }

    public static TPMT_SIGNATURE fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMT_SIGNATURE.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_SIGNATURE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMU_SIGNATURE", "signature", this.signature);
    }
}

