/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.Crypto;
import tss.Helpers;
import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.PCR_ReadResponse;
import tss.tpm.QuoteResponse;
import tss.tpm.TPMA_OBJECT;
import tss.tpm.TPMU_PUBLIC_ID;
import tss.tpm.TPMU_PUBLIC_PARMS;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.UnionFactory;

public class TPMT_PUBLIC
extends TpmStructure {
    public TPM_ALG_ID nameAlg;
    public TPMA_OBJECT objectAttributes;
    public byte[] authPolicy;
    public TPMU_PUBLIC_PARMS parameters;
    public TPMU_PUBLIC_ID unique;

    public TPM_ALG_ID type() {
        return this.parameters.GetUnionSelector();
    }

    public TPMT_PUBLIC() {
        this.nameAlg = TPM_ALG_ID.NULL;
    }

    public TPMT_PUBLIC(TPM_ALG_ID _nameAlg, TPMA_OBJECT _objectAttributes, byte[] _authPolicy, TPMU_PUBLIC_PARMS _parameters, TPMU_PUBLIC_ID _unique) {
        this.nameAlg = _nameAlg;
        this.objectAttributes = _objectAttributes;
        this.authPolicy = _authPolicy;
        this.parameters = _parameters;
        this.unique = _unique;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        if (this.parameters == null) {
            return;
        }
        buf.writeShort(this.parameters.GetUnionSelector());
        this.nameAlg.toTpm(buf);
        this.objectAttributes.toTpm(buf);
        buf.writeSizedByteBuf(this.authPolicy);
        this.parameters.toTpm(buf);
        this.unique.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        TPM_ALG_ID type = TPM_ALG_ID.fromTpm(buf);
        this.nameAlg = TPM_ALG_ID.fromTpm(buf);
        this.objectAttributes = TPMA_OBJECT.fromTpm(buf);
        this.authPolicy = buf.readSizedByteBuf();
        this.parameters = (TPMU_PUBLIC_PARMS)UnionFactory.create("TPMU_PUBLIC_PARMS", type);
        this.parameters.initFromTpm(buf);
        this.unique = (TPMU_PUBLIC_ID)UnionFactory.create("TPMU_PUBLIC_ID", type);
        this.unique.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMT_PUBLIC fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMT_PUBLIC.class);
    }

    public static TPMT_PUBLIC fromTpm(byte[] byteBuf) {
        return TPMT_PUBLIC.fromBytes(byteBuf);
    }

    public static TPMT_PUBLIC fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMT_PUBLIC.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_PUBLIC");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "nameAlg", this.nameAlg);
        _p.add(d, "TPMA_OBJECT", "objectAttributes", this.objectAttributes);
        _p.add(d, "byte[]", "authPolicy", this.authPolicy);
        _p.add(d, "TPMU_PUBLIC_PARMS", "parameters", this.parameters);
        _p.add(d, "TPMU_PUBLIC_ID", "unique", this.unique);
    }

    public boolean validateSignature(byte[] _dataThatWasSigned, TPMU_SIGNATURE _signature) {
        return Crypto.validateSignature(this, _dataThatWasSigned, _signature);
    }

    public byte[] encrypt(byte[] inData, String label) {
        return Crypto.asymEncrypt(this, inData, label);
    }

    public byte[] getName() {
        byte[] pub = this.toTpm();
        byte[] pubHash = Crypto.hash(this.nameAlg, pub);
        byte[] theHashAlg = Helpers.hostToNet((short)this.nameAlg.toInt());
        return Helpers.concatenate(theHashAlg, pubHash);
    }

    public boolean validateQuote(PCR_ReadResponse expectedPcrs, byte[] nonce, QuoteResponse quote) {
        return Crypto.validateQuote(this, expectedPcrs, nonce, quote);
    }
}

