/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_TIME_INFO;
import tss.tpm.TPMU_ATTEST;
import tss.tpm.TPM_ST;

public class TPMS_TIME_ATTEST_INFO
extends TpmStructure
implements TPMU_ATTEST {
    public TPMS_TIME_INFO time;
    public long firmwareVersion;

    public TPMS_TIME_ATTEST_INFO() {
    }

    public TPMS_TIME_ATTEST_INFO(TPMS_TIME_INFO _time, long _firmwareVersion) {
        this.time = _time;
        this.firmwareVersion = _firmwareVersion;
    }

    @Override
    public TPM_ST GetUnionSelector() {
        return TPM_ST.ATTEST_TIME;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.time.toTpm(buf);
        buf.writeInt64(this.firmwareVersion);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.time = TPMS_TIME_INFO.fromTpm(buf);
        this.firmwareVersion = buf.readInt64();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_TIME_ATTEST_INFO fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_TIME_ATTEST_INFO.class);
    }

    public static TPMS_TIME_ATTEST_INFO fromTpm(byte[] byteBuf) {
        return TPMS_TIME_ATTEST_INFO.fromBytes(byteBuf);
    }

    public static TPMS_TIME_ATTEST_INFO fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_TIME_ATTEST_INFO.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_TIME_ATTEST_INFO");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_TIME_INFO", "time", this.time);
        _p.add(d, "long", "firmwareVersion", this.firmwareVersion);
    }
}

