/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;

public class TPMS_SIGNATURE_RSA
extends TpmStructure
implements TPMU_SIGNATURE {
    public TPM_ALG_ID hash;
    public byte[] sig;

    public TPMS_SIGNATURE_RSA() {
        this.hash = TPM_ALG_ID.NULL;
    }

    public TPMS_SIGNATURE_RSA(TPM_ALG_ID _hash, byte[] _sig) {
        this.hash = _hash;
        this.sig = _sig;
    }

    @Override
    public TPM_ALG_ID GetUnionSelector() {
        return TPM_ALG_ID.RSASSA;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.hash.toTpm(buf);
        buf.writeSizedByteBuf(this.sig);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.hash = TPM_ALG_ID.fromTpm(buf);
        this.sig = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_SIGNATURE_RSA fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_SIGNATURE_RSA.class);
    }

    public static TPMS_SIGNATURE_RSA fromTpm(byte[] byteBuf) {
        return TPMS_SIGNATURE_RSA.fromBytes(byteBuf);
    }

    public static TPMS_SIGNATURE_RSA fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_SIGNATURE_RSA.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_SIGNATURE_RSA");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "hash", this.hash);
        _p.add(d, "byte[]", "sig", this.sig);
    }
}

