/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_ATTEST;
import tss.tpm.TPM_ST;

public class TPMS_SESSION_AUDIT_INFO
extends TpmStructure
implements TPMU_ATTEST {
    public byte exclusiveSession;
    public byte[] sessionDigest;

    public TPMS_SESSION_AUDIT_INFO() {
    }

    public TPMS_SESSION_AUDIT_INFO(byte _exclusiveSession, byte[] _sessionDigest) {
        this.exclusiveSession = _exclusiveSession;
        this.sessionDigest = _sessionDigest;
    }

    @Override
    public TPM_ST GetUnionSelector() {
        return TPM_ST.ATTEST_SESSION_AUDIT;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeByte(this.exclusiveSession);
        buf.writeSizedByteBuf(this.sessionDigest);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.exclusiveSession = buf.readByte();
        this.sessionDigest = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_SESSION_AUDIT_INFO fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_SESSION_AUDIT_INFO.class);
    }

    public static TPMS_SESSION_AUDIT_INFO fromTpm(byte[] byteBuf) {
        return TPMS_SESSION_AUDIT_INFO.fromBytes(byteBuf);
    }

    public static TPMS_SESSION_AUDIT_INFO fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_SESSION_AUDIT_INFO.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_SESSION_AUDIT_INFO");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "exclusiveSession", this.exclusiveSession);
        _p.add(d, "byte[]", "sessionDigest", this.sessionDigest);
    }
}

