/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_NV;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPMS_NV_PUBLIC
extends TpmStructure {
    public TPM_HANDLE nvIndex;
    public TPM_ALG_ID nameAlg;
    public TPMA_NV attributes;
    public byte[] authPolicy;
    public int dataSize;

    public TPMS_NV_PUBLIC() {
        this.nvIndex = new TPM_HANDLE();
        this.nameAlg = TPM_ALG_ID.NULL;
    }

    public TPMS_NV_PUBLIC(TPM_HANDLE _nvIndex, TPM_ALG_ID _nameAlg, TPMA_NV _attributes, byte[] _authPolicy, int _dataSize) {
        this.nvIndex = _nvIndex;
        this.nameAlg = _nameAlg;
        this.attributes = _attributes;
        this.authPolicy = _authPolicy;
        this.dataSize = _dataSize;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.nvIndex.toTpm(buf);
        this.nameAlg.toTpm(buf);
        this.attributes.toTpm(buf);
        buf.writeSizedByteBuf(this.authPolicy);
        buf.writeShort(this.dataSize);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.nvIndex = TPM_HANDLE.fromTpm(buf);
        this.nameAlg = TPM_ALG_ID.fromTpm(buf);
        this.attributes = TPMA_NV.fromTpm(buf);
        this.authPolicy = buf.readSizedByteBuf();
        this.dataSize = buf.readShort();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_NV_PUBLIC fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_NV_PUBLIC.class);
    }

    public static TPMS_NV_PUBLIC fromTpm(byte[] byteBuf) {
        return TPMS_NV_PUBLIC.fromBytes(byteBuf);
    }

    public static TPMS_NV_PUBLIC fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_NV_PUBLIC.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_NV_PUBLIC");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "nvIndex", this.nvIndex);
        _p.add(d, "TPM_ALG_ID", "nameAlg", this.nameAlg);
        _p.add(d, "TPMA_NV", "attributes", this.attributes);
        _p.add(d, "byte[]", "authPolicy", this.authPolicy);
        _p.add(d, "int", "dataSize", this.dataSize);
    }
}

