/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_SYM_DEF_OBJECT;
import tss.tpm.TPMU_ASYM_SCHEME;
import tss.tpm.TPMU_KDF_SCHEME;
import tss.tpm.TPMU_PUBLIC_PARMS;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_ECC_CURVE;
import tss.tpm.UnionFactory;

public class TPMS_ECC_PARMS
extends TpmStructure
implements TPMU_PUBLIC_PARMS {
    public TPMT_SYM_DEF_OBJECT symmetric;
    public TPMU_ASYM_SCHEME scheme;
    public TPM_ECC_CURVE curveID;
    public TPMU_KDF_SCHEME kdf;

    public TPM_ALG_ID schemeScheme() {
        return this.scheme != null ? this.scheme.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM_ALG_ID kdfScheme() {
        return this.kdf != null ? this.kdf.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPMS_ECC_PARMS() {
    }

    public TPMS_ECC_PARMS(TPMT_SYM_DEF_OBJECT _symmetric, TPMU_ASYM_SCHEME _scheme, TPM_ECC_CURVE _curveID, TPMU_KDF_SCHEME _kdf) {
        this.symmetric = _symmetric;
        this.scheme = _scheme;
        this.curveID = _curveID;
        this.kdf = _kdf;
    }

    @Override
    public TPM_ALG_ID GetUnionSelector() {
        return TPM_ALG_ID.ECC;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.symmetric.toTpm(buf);
        buf.writeShort(this.scheme.GetUnionSelector());
        this.scheme.toTpm(buf);
        this.curveID.toTpm(buf);
        buf.writeShort(this.kdf.GetUnionSelector());
        this.kdf.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.symmetric = TPMT_SYM_DEF_OBJECT.fromTpm(buf);
        TPM_ALG_ID schemeScheme = TPM_ALG_ID.fromTpm(buf);
        this.scheme = (TPMU_ASYM_SCHEME)UnionFactory.create("TPMU_ASYM_SCHEME", schemeScheme);
        this.scheme.initFromTpm(buf);
        this.curveID = TPM_ECC_CURVE.fromTpm(buf);
        TPM_ALG_ID kdfScheme = TPM_ALG_ID.fromTpm(buf);
        this.kdf = (TPMU_KDF_SCHEME)UnionFactory.create("TPMU_KDF_SCHEME", kdfScheme);
        this.kdf.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_ECC_PARMS fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_ECC_PARMS.class);
    }

    public static TPMS_ECC_PARMS fromTpm(byte[] byteBuf) {
        return TPMS_ECC_PARMS.fromBytes(byteBuf);
    }

    public static TPMS_ECC_PARMS fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_ECC_PARMS.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_ECC_PARMS");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMT_SYM_DEF_OBJECT", "symmetric", this.symmetric);
        _p.add(d, "TPMU_ASYM_SCHEME", "scheme", this.scheme);
        _p.add(d, "TPM_ECC_CURVE", "curveID", this.curveID);
        _p.add(d, "TPMU_KDF_SCHEME", "kdf", this.kdf);
    }
}

