/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_LOCALITY;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPM_ALG_ID;

public class TPMS_CREATION_DATA
extends TpmStructure {
    public TPMS_PCR_SELECTION[] pcrSelect;
    public byte[] pcrDigest;
    public TPMA_LOCALITY locality;
    public TPM_ALG_ID parentNameAlg;
    public byte[] parentName;
    public byte[] parentQualifiedName;
    public byte[] outsideInfo;

    public TPMS_CREATION_DATA() {
        this.parentNameAlg = TPM_ALG_ID.NULL;
    }

    public TPMS_CREATION_DATA(TPMS_PCR_SELECTION[] _pcrSelect, byte[] _pcrDigest, TPMA_LOCALITY _locality, TPM_ALG_ID _parentNameAlg, byte[] _parentName, byte[] _parentQualifiedName, byte[] _outsideInfo) {
        this.pcrSelect = _pcrSelect;
        this.pcrDigest = _pcrDigest;
        this.locality = _locality;
        this.parentNameAlg = _parentNameAlg;
        this.parentName = _parentName;
        this.parentQualifiedName = _parentQualifiedName;
        this.outsideInfo = _outsideInfo;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeObjArr(this.pcrSelect);
        buf.writeSizedByteBuf(this.pcrDigest);
        this.locality.toTpm(buf);
        this.parentNameAlg.toTpm(buf);
        buf.writeSizedByteBuf(this.parentName);
        buf.writeSizedByteBuf(this.parentQualifiedName);
        buf.writeSizedByteBuf(this.outsideInfo);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.pcrSelect = (TPMS_PCR_SELECTION[])buf.readObjArr(TPMS_PCR_SELECTION.class);
        this.pcrDigest = buf.readSizedByteBuf();
        this.locality = TPMA_LOCALITY.fromTpm(buf);
        this.parentNameAlg = TPM_ALG_ID.fromTpm(buf);
        this.parentName = buf.readSizedByteBuf();
        this.parentQualifiedName = buf.readSizedByteBuf();
        this.outsideInfo = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_CREATION_DATA fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_CREATION_DATA.class);
    }

    public static TPMS_CREATION_DATA fromTpm(byte[] byteBuf) {
        return TPMS_CREATION_DATA.fromBytes(byteBuf);
    }

    public static TPMS_CREATION_DATA fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_CREATION_DATA.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_CREATION_DATA");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_PCR_SELECTION[]", "pcrSelect", this.pcrSelect);
        _p.add(d, "byte[]", "pcrDigest", this.pcrDigest);
        _p.add(d, "TPMA_LOCALITY", "locality", this.locality);
        _p.add(d, "TPM_ALG_ID", "parentNameAlg", this.parentNameAlg);
        _p.add(d, "byte[]", "parentName", this.parentName);
        _p.add(d, "byte[]", "parentQualifiedName", this.parentQualifiedName);
        _p.add(d, "byte[]", "outsideInfo", this.outsideInfo);
    }
}

