/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_SESSION;

public class TPMS_AUTH_RESPONSE
extends TpmStructure {
    public byte[] nonce;
    public TPMA_SESSION sessionAttributes;
    public byte[] hmac;

    public TPMS_AUTH_RESPONSE() {
    }

    public TPMS_AUTH_RESPONSE(byte[] _nonce, TPMA_SESSION _sessionAttributes, byte[] _hmac) {
        this.nonce = _nonce;
        this.sessionAttributes = _sessionAttributes;
        this.hmac = _hmac;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.nonce);
        this.sessionAttributes.toTpm(buf);
        buf.writeSizedByteBuf(this.hmac);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.nonce = buf.readSizedByteBuf();
        this.sessionAttributes = TPMA_SESSION.fromTpm(buf);
        this.hmac = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_AUTH_RESPONSE fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_AUTH_RESPONSE.class);
    }

    public static TPMS_AUTH_RESPONSE fromTpm(byte[] byteBuf) {
        return TPMS_AUTH_RESPONSE.fromBytes(byteBuf);
    }

    public static TPMS_AUTH_RESPONSE fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_AUTH_RESPONSE.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_AUTH_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte[]", "nonce", this.nonce);
        _p.add(d, "TPMA_SESSION", "sessionAttributes", this.sessionAttributes);
        _p.add(d, "byte[]", "hmac", this.hmac);
    }
}

