/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_SESSION;
import tss.tpm.TPM_HANDLE;

public class TPMS_AUTH_COMMAND
extends TpmStructure {
    public TPM_HANDLE sessionHandle;
    public byte[] nonce;
    public TPMA_SESSION sessionAttributes;
    public byte[] hmac;

    public TPMS_AUTH_COMMAND() {
        this.sessionHandle = new TPM_HANDLE();
    }

    public TPMS_AUTH_COMMAND(TPM_HANDLE _sessionHandle, byte[] _nonce, TPMA_SESSION _sessionAttributes, byte[] _hmac) {
        this.sessionHandle = _sessionHandle;
        this.nonce = _nonce;
        this.sessionAttributes = _sessionAttributes;
        this.hmac = _hmac;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.sessionHandle.toTpm(buf);
        buf.writeSizedByteBuf(this.nonce);
        this.sessionAttributes.toTpm(buf);
        buf.writeSizedByteBuf(this.hmac);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.sessionHandle = TPM_HANDLE.fromTpm(buf);
        this.nonce = buf.readSizedByteBuf();
        this.sessionAttributes = TPMA_SESSION.fromTpm(buf);
        this.hmac = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_AUTH_COMMAND fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_AUTH_COMMAND.class);
    }

    public static TPMS_AUTH_COMMAND fromTpm(byte[] byteBuf) {
        return TPMS_AUTH_COMMAND.fromBytes(byteBuf);
    }

    public static TPMS_AUTH_COMMAND fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_AUTH_COMMAND.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_AUTH_COMMAND");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "sessionHandle", this.sessionHandle);
        _p.add(d, "byte[]", "nonce", this.nonce);
        _p.add(d, "TPMA_SESSION", "sessionAttributes", this.sessionAttributes);
        _p.add(d, "byte[]", "hmac", this.hmac);
    }
}

