/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_ASYM_SCHEME;
import tss.tpm.TPMU_KDF_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_ECC_CURVE;
import tss.tpm.UnionFactory;

public class TPMS_ALGORITHM_DETAIL_ECC
extends TpmStructure {
    public TPM_ECC_CURVE curveID;
    public int keySize;
    public TPMU_KDF_SCHEME kdf;
    public TPMU_ASYM_SCHEME sign;
    public byte[] p;
    public byte[] a;
    public byte[] b;
    public byte[] gX;
    public byte[] gY;
    public byte[] n;
    public byte[] h;

    public TPM_ALG_ID kdfScheme() {
        return this.kdf != null ? this.kdf.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM_ALG_ID signScheme() {
        return this.sign != null ? this.sign.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPMS_ALGORITHM_DETAIL_ECC() {
    }

    public TPMS_ALGORITHM_DETAIL_ECC(TPM_ECC_CURVE _curveID, int _keySize, TPMU_KDF_SCHEME _kdf, TPMU_ASYM_SCHEME _sign, byte[] _p, byte[] _a, byte[] _b, byte[] _gX, byte[] _gY, byte[] _n, byte[] _h) {
        this.curveID = _curveID;
        this.keySize = _keySize;
        this.kdf = _kdf;
        this.sign = _sign;
        this.p = _p;
        this.a = _a;
        this.b = _b;
        this.gX = _gX;
        this.gY = _gY;
        this.n = _n;
        this.h = _h;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.curveID.toTpm(buf);
        buf.writeShort(this.keySize);
        buf.writeShort(this.kdf.GetUnionSelector());
        this.kdf.toTpm(buf);
        buf.writeShort(this.sign.GetUnionSelector());
        this.sign.toTpm(buf);
        buf.writeSizedByteBuf(this.p);
        buf.writeSizedByteBuf(this.a);
        buf.writeSizedByteBuf(this.b);
        buf.writeSizedByteBuf(this.gX);
        buf.writeSizedByteBuf(this.gY);
        buf.writeSizedByteBuf(this.n);
        buf.writeSizedByteBuf(this.h);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.curveID = TPM_ECC_CURVE.fromTpm(buf);
        this.keySize = buf.readShort();
        TPM_ALG_ID kdfScheme = TPM_ALG_ID.fromTpm(buf);
        this.kdf = (TPMU_KDF_SCHEME)UnionFactory.create("TPMU_KDF_SCHEME", kdfScheme);
        this.kdf.initFromTpm(buf);
        TPM_ALG_ID signScheme = TPM_ALG_ID.fromTpm(buf);
        this.sign = (TPMU_ASYM_SCHEME)UnionFactory.create("TPMU_ASYM_SCHEME", signScheme);
        this.sign.initFromTpm(buf);
        this.p = buf.readSizedByteBuf();
        this.a = buf.readSizedByteBuf();
        this.b = buf.readSizedByteBuf();
        this.gX = buf.readSizedByteBuf();
        this.gY = buf.readSizedByteBuf();
        this.n = buf.readSizedByteBuf();
        this.h = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_ALGORITHM_DETAIL_ECC fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_ALGORITHM_DETAIL_ECC.class);
    }

    public static TPMS_ALGORITHM_DETAIL_ECC fromTpm(byte[] byteBuf) {
        return TPMS_ALGORITHM_DETAIL_ECC.fromBytes(byteBuf);
    }

    public static TPMS_ALGORITHM_DETAIL_ECC fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_ALGORITHM_DETAIL_ECC.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_ALGORITHM_DETAIL_ECC");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ECC_CURVE", "curveID", this.curveID);
        _p.add(d, "int", "keySize", this.keySize);
        _p.add(d, "TPMU_KDF_SCHEME", "kdf", this.kdf);
        _p.add(d, "TPMU_ASYM_SCHEME", "sign", this.sign);
        _p.add(d, "byte[]", "p", this.p);
        _p.add(d, "byte[]", "a", this.a);
        _p.add(d, "byte[]", "b", this.b);
        _p.add(d, "byte[]", "gX", this.gX);
        _p.add(d, "byte[]", "gY", this.gY);
        _p.add(d, "byte[]", "n", this.n);
        _p.add(d, "byte[]", "h", this.h);
    }
}

