/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.UnionFactory;

public class TPM2_VerifySignature_REQUEST
extends ReqStructure {
    public TPM_HANDLE keyHandle;
    public byte[] digest;
    public TPMU_SIGNATURE signature;

    public TPM_ALG_ID signatureSigAlg() {
        return this.signature != null ? this.signature.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM2_VerifySignature_REQUEST() {
        this.keyHandle = new TPM_HANDLE();
    }

    public TPM2_VerifySignature_REQUEST(TPM_HANDLE _keyHandle, byte[] _digest, TPMU_SIGNATURE _signature) {
        this.keyHandle = _keyHandle;
        this.digest = _digest;
        this.signature = _signature;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.digest);
        buf.writeShort(this.signature.GetUnionSelector());
        this.signature.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.digest = buf.readSizedByteBuf();
        TPM_ALG_ID signatureSigAlg = TPM_ALG_ID.fromTpm(buf);
        this.signature = (TPMU_SIGNATURE)UnionFactory.create("TPMU_SIGNATURE", signatureSigAlg);
        this.signature.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_VerifySignature_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_VerifySignature_REQUEST.class);
    }

    public static TPM2_VerifySignature_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_VerifySignature_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_VerifySignature_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_VerifySignature_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_VerifySignature_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "byte[]", "digest", this.digest);
        _p.add(d, "TPMU_SIGNATURE", "signature", this.signature);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 0;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.keyHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

