/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPM_HANDLE;

public class TPM2_Rewrap_REQUEST
extends ReqStructure {
    public TPM_HANDLE oldParent;
    public TPM_HANDLE newParent;
    public TPM2B_PRIVATE inDuplicate;
    public byte[] name;
    public byte[] inSymSeed;

    public TPM2_Rewrap_REQUEST() {
        this.oldParent = new TPM_HANDLE();
        this.newParent = new TPM_HANDLE();
    }

    public TPM2_Rewrap_REQUEST(TPM_HANDLE _oldParent, TPM_HANDLE _newParent, TPM2B_PRIVATE _inDuplicate, byte[] _name, byte[] _inSymSeed) {
        this.oldParent = _oldParent;
        this.newParent = _newParent;
        this.inDuplicate = _inDuplicate;
        this.name = _name;
        this.inSymSeed = _inSymSeed;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.inDuplicate.toTpm(buf);
        buf.writeSizedByteBuf(this.name);
        buf.writeSizedByteBuf(this.inSymSeed);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.inDuplicate = TPM2B_PRIVATE.fromTpm(buf);
        this.name = buf.readSizedByteBuf();
        this.inSymSeed = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_Rewrap_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_Rewrap_REQUEST.class);
    }

    public static TPM2_Rewrap_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_Rewrap_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_Rewrap_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_Rewrap_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Rewrap_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "oldParent", this.oldParent);
        _p.add(d, "TPM_HANDLE", "newParent", this.newParent);
        _p.add(d, "TPM2B_PRIVATE", "inDuplicate", this.inDuplicate);
        _p.add(d, "byte[]", "name", this.name);
        _p.add(d, "byte[]", "inSymSeed", this.inSymSeed);
    }

    @Override
    public int numHandles() {
        return 2;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.oldParent, this.newParent};
    }
}

