/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicySecret_REQUEST
extends ReqStructure {
    public TPM_HANDLE authHandle;
    public TPM_HANDLE policySession;
    public byte[] nonceTPM;
    public byte[] cpHashA;
    public byte[] policyRef;
    public int expiration;

    public TPM2_PolicySecret_REQUEST() {
        this.authHandle = new TPM_HANDLE();
        this.policySession = new TPM_HANDLE();
    }

    public TPM2_PolicySecret_REQUEST(TPM_HANDLE _authHandle, TPM_HANDLE _policySession, byte[] _nonceTPM, byte[] _cpHashA, byte[] _policyRef, int _expiration) {
        this.authHandle = _authHandle;
        this.policySession = _policySession;
        this.nonceTPM = _nonceTPM;
        this.cpHashA = _cpHashA;
        this.policyRef = _policyRef;
        this.expiration = _expiration;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.nonceTPM);
        buf.writeSizedByteBuf(this.cpHashA);
        buf.writeSizedByteBuf(this.policyRef);
        buf.writeInt(this.expiration);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.nonceTPM = buf.readSizedByteBuf();
        this.cpHashA = buf.readSizedByteBuf();
        this.policyRef = buf.readSizedByteBuf();
        this.expiration = buf.readInt();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_PolicySecret_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_PolicySecret_REQUEST.class);
    }

    public static TPM2_PolicySecret_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_PolicySecret_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_PolicySecret_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_PolicySecret_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicySecret_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authHandle", this.authHandle);
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte[]", "nonceTPM", this.nonceTPM);
        _p.add(d, "byte[]", "cpHashA", this.cpHashA);
        _p.add(d, "byte[]", "policyRef", this.policyRef);
        _p.add(d, "int", "expiration", this.expiration);
    }

    @Override
    public int numHandles() {
        return 2;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.authHandle, this.policySession};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

