/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_MakeCredential_REQUEST
extends ReqStructure {
    public TPM_HANDLE handle;
    public byte[] credential;
    public byte[] objectName;

    public TPM2_MakeCredential_REQUEST() {
        this.handle = new TPM_HANDLE();
    }

    public TPM2_MakeCredential_REQUEST(TPM_HANDLE _handle, byte[] _credential, byte[] _objectName) {
        this.handle = _handle;
        this.credential = _credential;
        this.objectName = _objectName;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.credential);
        buf.writeSizedByteBuf(this.objectName);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.credential = buf.readSizedByteBuf();
        this.objectName = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_MakeCredential_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_MakeCredential_REQUEST.class);
    }

    public static TPM2_MakeCredential_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_MakeCredential_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_MakeCredential_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_MakeCredential_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_MakeCredential_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "byte[]", "credential", this.credential);
        _p.add(d, "byte[]", "objectName", this.objectName);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 0;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.handle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

