/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_SENSITIVE;
import tss.tpm.TPM_HANDLE;

public class TPM2_LoadExternal_REQUEST
extends ReqStructure {
    public TPMT_SENSITIVE inPrivate;
    public TPMT_PUBLIC inPublic;
    public TPM_HANDLE hierarchy;

    public TPM2_LoadExternal_REQUEST() {
        this.hierarchy = new TPM_HANDLE();
    }

    public TPM2_LoadExternal_REQUEST(TPMT_SENSITIVE _inPrivate, TPMT_PUBLIC _inPublic, TPM_HANDLE _hierarchy) {
        this.inPrivate = _inPrivate;
        this.inPublic = _inPublic;
        this.hierarchy = _hierarchy;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedObj(this.inPrivate);
        buf.writeSizedObj(this.inPublic);
        this.hierarchy.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.inPrivate = buf.createSizedObj(TPMT_SENSITIVE.class);
        this.inPublic = buf.createSizedObj(TPMT_PUBLIC.class);
        this.hierarchy = TPM_HANDLE.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_LoadExternal_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_LoadExternal_REQUEST.class);
    }

    public static TPM2_LoadExternal_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_LoadExternal_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_LoadExternal_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_LoadExternal_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_LoadExternal_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMT_SENSITIVE", "inPrivate", this.inPrivate);
        _p.add(d, "TPMT_PUBLIC", "inPublic", this.inPublic);
        _p.add(d, "TPM_HANDLE", "hierarchy", this.hierarchy);
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

