/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_SYM_DEF_OBJECT;
import tss.tpm.TPM_HANDLE;

public class TPM2_Import_REQUEST
extends ReqStructure {
    public TPM_HANDLE parentHandle;
    public byte[] encryptionKey;
    public TPMT_PUBLIC objectPublic;
    public TPM2B_PRIVATE duplicate;
    public byte[] inSymSeed;
    public TPMT_SYM_DEF_OBJECT symmetricAlg;

    public TPM2_Import_REQUEST() {
        this.parentHandle = new TPM_HANDLE();
    }

    public TPM2_Import_REQUEST(TPM_HANDLE _parentHandle, byte[] _encryptionKey, TPMT_PUBLIC _objectPublic, TPM2B_PRIVATE _duplicate, byte[] _inSymSeed, TPMT_SYM_DEF_OBJECT _symmetricAlg) {
        this.parentHandle = _parentHandle;
        this.encryptionKey = _encryptionKey;
        this.objectPublic = _objectPublic;
        this.duplicate = _duplicate;
        this.inSymSeed = _inSymSeed;
        this.symmetricAlg = _symmetricAlg;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.encryptionKey);
        buf.writeSizedObj(this.objectPublic);
        this.duplicate.toTpm(buf);
        buf.writeSizedByteBuf(this.inSymSeed);
        this.symmetricAlg.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.encryptionKey = buf.readSizedByteBuf();
        this.objectPublic = buf.createSizedObj(TPMT_PUBLIC.class);
        this.duplicate = TPM2B_PRIVATE.fromTpm(buf);
        this.inSymSeed = buf.readSizedByteBuf();
        this.symmetricAlg = TPMT_SYM_DEF_OBJECT.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_Import_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_Import_REQUEST.class);
    }

    public static TPM2_Import_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_Import_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_Import_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_Import_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Import_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "parentHandle", this.parentHandle);
        _p.add(d, "byte[]", "encryptionKey", this.encryptionKey);
        _p.add(d, "TPMT_PUBLIC", "objectPublic", this.objectPublic);
        _p.add(d, "TPM2B_PRIVATE", "duplicate", this.duplicate);
        _p.add(d, "byte[]", "inSymSeed", this.inSymSeed);
        _p.add(d, "TPMT_SYM_DEF_OBJECT", "symmetricAlg", this.symmetricAlg);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.parentHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

