/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_Hash_REQUEST
extends ReqStructure {
    public byte[] data;
    public TPM_ALG_ID hashAlg;
    public TPM_HANDLE hierarchy;

    public TPM2_Hash_REQUEST() {
        this.hashAlg = TPM_ALG_ID.NULL;
        this.hierarchy = new TPM_HANDLE();
    }

    public TPM2_Hash_REQUEST(byte[] _data, TPM_ALG_ID _hashAlg, TPM_HANDLE _hierarchy) {
        this.data = _data;
        this.hashAlg = _hashAlg;
        this.hierarchy = _hierarchy;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.data);
        this.hashAlg.toTpm(buf);
        this.hierarchy.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.data = buf.readSizedByteBuf();
        this.hashAlg = TPM_ALG_ID.fromTpm(buf);
        this.hierarchy = TPM_HANDLE.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_Hash_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_Hash_REQUEST.class);
    }

    public static TPM2_Hash_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_Hash_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_Hash_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_Hash_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Hash_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte[]", "data", this.data);
        _p.add(d, "TPM_ALG_ID", "hashAlg", this.hashAlg);
        _p.add(d, "TPM_HANDLE", "hierarchy", this.hierarchy);
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

