/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_KDF_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.UnionFactory;

public class TPM2_ECC_Encrypt_REQUEST
extends ReqStructure {
    public TPM_HANDLE keyHandle;
    public byte[] plainText;
    public TPMU_KDF_SCHEME inScheme;

    public TPM_ALG_ID inSchemeScheme() {
        return this.inScheme != null ? this.inScheme.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM2_ECC_Encrypt_REQUEST() {
        this.keyHandle = new TPM_HANDLE();
    }

    public TPM2_ECC_Encrypt_REQUEST(TPM_HANDLE _keyHandle, byte[] _plainText, TPMU_KDF_SCHEME _inScheme) {
        this.keyHandle = _keyHandle;
        this.plainText = _plainText;
        this.inScheme = _inScheme;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.plainText);
        buf.writeShort(this.inScheme.GetUnionSelector());
        this.inScheme.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.plainText = buf.readSizedByteBuf();
        TPM_ALG_ID inSchemeScheme = TPM_ALG_ID.fromTpm(buf);
        this.inScheme = (TPMU_KDF_SCHEME)UnionFactory.create("TPMU_KDF_SCHEME", inSchemeScheme);
        this.inScheme.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_ECC_Encrypt_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_ECC_Encrypt_REQUEST.class);
    }

    public static TPM2_ECC_Encrypt_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_ECC_Encrypt_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_ECC_Encrypt_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_ECC_Encrypt_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_ECC_Encrypt_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "byte[]", "plainText", this.plainText);
        _p.add(d, "TPMU_KDF_SCHEME", "inScheme", this.inScheme);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 0;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.keyHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

