/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_SYM_DEF_OBJECT;
import tss.tpm.TPM_HANDLE;

public class TPM2_Duplicate_REQUEST
extends ReqStructure {
    public TPM_HANDLE objectHandle;
    public TPM_HANDLE newParentHandle;
    public byte[] encryptionKeyIn;
    public TPMT_SYM_DEF_OBJECT symmetricAlg;

    public TPM2_Duplicate_REQUEST() {
        this.objectHandle = new TPM_HANDLE();
        this.newParentHandle = new TPM_HANDLE();
    }

    public TPM2_Duplicate_REQUEST(TPM_HANDLE _objectHandle, TPM_HANDLE _newParentHandle, byte[] _encryptionKeyIn, TPMT_SYM_DEF_OBJECT _symmetricAlg) {
        this.objectHandle = _objectHandle;
        this.newParentHandle = _newParentHandle;
        this.encryptionKeyIn = _encryptionKeyIn;
        this.symmetricAlg = _symmetricAlg;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.encryptionKeyIn);
        this.symmetricAlg.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.encryptionKeyIn = buf.readSizedByteBuf();
        this.symmetricAlg = TPMT_SYM_DEF_OBJECT.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_Duplicate_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_Duplicate_REQUEST.class);
    }

    public static TPM2_Duplicate_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_Duplicate_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_Duplicate_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_Duplicate_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Duplicate_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "objectHandle", this.objectHandle);
        _p.add(d, "TPM_HANDLE", "newParentHandle", this.newParentHandle);
        _p.add(d, "byte[]", "encryptionKeyIn", this.encryptionKeyIn);
        _p.add(d, "TPMT_SYM_DEF_OBJECT", "symmetricAlg", this.symmetricAlg);
    }

    @Override
    public int numHandles() {
        return 2;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.objectHandle, this.newParentHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

