/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIG_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.UnionFactory;

public class TPM2_CertifyX509_REQUEST
extends ReqStructure {
    public TPM_HANDLE objectHandle;
    public TPM_HANDLE signHandle;
    public byte[] reserved;
    public TPMU_SIG_SCHEME inScheme;
    public byte[] partialCertificate;

    public TPM_ALG_ID inSchemeScheme() {
        return this.inScheme != null ? this.inScheme.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM2_CertifyX509_REQUEST() {
        this.objectHandle = new TPM_HANDLE();
        this.signHandle = new TPM_HANDLE();
    }

    public TPM2_CertifyX509_REQUEST(TPM_HANDLE _objectHandle, TPM_HANDLE _signHandle, byte[] _reserved, TPMU_SIG_SCHEME _inScheme, byte[] _partialCertificate) {
        this.objectHandle = _objectHandle;
        this.signHandle = _signHandle;
        this.reserved = _reserved;
        this.inScheme = _inScheme;
        this.partialCertificate = _partialCertificate;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.reserved);
        buf.writeShort(this.inScheme.GetUnionSelector());
        this.inScheme.toTpm(buf);
        buf.writeSizedByteBuf(this.partialCertificate);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.reserved = buf.readSizedByteBuf();
        TPM_ALG_ID inSchemeScheme = TPM_ALG_ID.fromTpm(buf);
        this.inScheme = (TPMU_SIG_SCHEME)UnionFactory.create("TPMU_SIG_SCHEME", inSchemeScheme);
        this.inScheme.initFromTpm(buf);
        this.partialCertificate = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_CertifyX509_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_CertifyX509_REQUEST.class);
    }

    public static TPM2_CertifyX509_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_CertifyX509_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_CertifyX509_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_CertifyX509_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_CertifyX509_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "objectHandle", this.objectHandle);
        _p.add(d, "TPM_HANDLE", "signHandle", this.signHandle);
        _p.add(d, "byte[]", "reserved", this.reserved);
        _p.add(d, "TPMU_SIG_SCHEME", "inScheme", this.inScheme);
        _p.add(d, "byte[]", "partialCertificate", this.partialCertificate);
    }

    @Override
    public int numHandles() {
        return 2;
    }

    @Override
    public int numAuthHandles() {
        return 2;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.objectHandle, this.signHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

