/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_SESSION;
import tss.tpm.TPM_HANDLE;

public class SessionIn
extends TpmStructure {
    public TPM_HANDLE handle;
    public byte[] nonceCaller;
    public TPMA_SESSION attributes;
    public byte[] auth;

    public SessionIn() {
        this.handle = new TPM_HANDLE();
    }

    public SessionIn(TPM_HANDLE _handle, byte[] _nonceCaller, TPMA_SESSION _attributes, byte[] _auth) {
        this.handle = _handle;
        this.nonceCaller = _nonceCaller;
        this.attributes = _attributes;
        this.auth = _auth;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.handle.toTpm(buf);
        buf.writeSizedByteBuf(this.nonceCaller);
        this.attributes.toTpm(buf);
        buf.writeSizedByteBuf(this.auth);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.handle = TPM_HANDLE.fromTpm(buf);
        this.nonceCaller = buf.readSizedByteBuf();
        this.attributes = TPMA_SESSION.fromTpm(buf);
        this.auth = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static SessionIn fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(SessionIn.class);
    }

    public static SessionIn fromTpm(byte[] byteBuf) {
        return SessionIn.fromBytes(byteBuf);
    }

    public static SessionIn fromTpm(TpmBuffer buf) {
        return buf.createObj(SessionIn.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("SessionIn");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "byte[]", "nonceCaller", this.nonceCaller);
        _p.add(d, "TPMA_SESSION", "attributes", this.attributes);
        _p.add(d, "byte[]", "auth", this.auth);
    }
}

