/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.RespStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ATTEST;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.UnionFactory;

public class QuoteResponse
extends RespStructure {
    public TPMS_ATTEST quoted;
    public TPMU_SIGNATURE signature;

    public TPM_ALG_ID signatureSigAlg() {
        return this.signature != null ? this.signature.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedObj(this.quoted);
        buf.writeShort(this.signature.GetUnionSelector());
        this.signature.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.quoted = buf.createSizedObj(TPMS_ATTEST.class);
        TPM_ALG_ID signatureSigAlg = TPM_ALG_ID.fromTpm(buf);
        this.signature = (TPMU_SIGNATURE)UnionFactory.create("TPMU_SIGNATURE", signatureSigAlg);
        this.signature.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static QuoteResponse fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(QuoteResponse.class);
    }

    public static QuoteResponse fromTpm(byte[] byteBuf) {
        return QuoteResponse.fromBytes(byteBuf);
    }

    public static QuoteResponse fromTpm(TpmBuffer buf) {
        return buf.createObj(QuoteResponse.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("QuoteResponse");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_ATTEST", "quoted", this.quoted);
        _p.add(d, "TPMU_SIGNATURE", "signature", this.signature);
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

