/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Collection;
import tss.TpmBuffer;
import tss.TpmEnum;
import tss.tpm.Implementation;
import tss.tpm.TPM_CC;

public final class ImplementationConstants
extends TpmEnum<ImplementationConstants> {
    private static TpmEnum.ValueMap<ImplementationConstants> _ValueMap = new TpmEnum.ValueMap();
    public static final ImplementationConstants Ossl = new ImplementationConstants(1, _N.Ossl);
    public static final ImplementationConstants Ltc = new ImplementationConstants(2, _N.Ltc);
    public static final ImplementationConstants Msbn = new ImplementationConstants(3, _N.Msbn);
    public static final ImplementationConstants Symcrypt = new ImplementationConstants(4, _N.Symcrypt);
    public static final ImplementationConstants HASH_COUNT = new ImplementationConstants(3, _N.HASH_COUNT);
    public static final ImplementationConstants MAX_SYM_KEY_BITS = new ImplementationConstants(256, _N.MAX_SYM_KEY_BITS);
    public static final ImplementationConstants MAX_SYM_KEY_BYTES = new ImplementationConstants((MAX_SYM_KEY_BITS.toInt() + 7) / 8, _N.MAX_SYM_KEY_BYTES);
    public static final ImplementationConstants MAX_SYM_BLOCK_SIZE = new ImplementationConstants(16, _N.MAX_SYM_BLOCK_SIZE);
    public static final ImplementationConstants MAX_CAP_CC = new ImplementationConstants(TPM_CC.LAST.toInt(), _N.MAX_CAP_CC);
    public static final ImplementationConstants MAX_RSA_KEY_BYTES = new ImplementationConstants(256, _N.MAX_RSA_KEY_BYTES);
    public static final ImplementationConstants MAX_AES_KEY_BYTES = new ImplementationConstants(32, _N.MAX_AES_KEY_BYTES);
    public static final ImplementationConstants MAX_ECC_KEY_BYTES = new ImplementationConstants(48, _N.MAX_ECC_KEY_BYTES);
    public static final ImplementationConstants LABEL_MAX_BUFFER = new ImplementationConstants(32, _N.LABEL_MAX_BUFFER);
    public static final ImplementationConstants _TPM_CAP_SIZE = new ImplementationConstants(4, _N._TPM_CAP_SIZE);
    public static final ImplementationConstants MAX_CAP_DATA = new ImplementationConstants(Implementation.MAX_CAP_BUFFER.toInt() - _TPM_CAP_SIZE.toInt() - 4, _N.MAX_CAP_DATA);
    public static final ImplementationConstants MAX_CAP_ALGS = new ImplementationConstants(MAX_CAP_DATA.toInt() / 6, _N.MAX_CAP_ALGS);
    public static final ImplementationConstants MAX_CAP_HANDLES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 4, _N.MAX_CAP_HANDLES);
    public static final ImplementationConstants MAX_TPM_PROPERTIES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 8, _N.MAX_TPM_PROPERTIES);
    public static final ImplementationConstants MAX_PCR_PROPERTIES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 5, _N.MAX_PCR_PROPERTIES);
    public static final ImplementationConstants MAX_ECC_CURVES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 2, _N.MAX_ECC_CURVES);
    public static final ImplementationConstants MAX_TAGGED_POLICIES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 70, _N.MAX_TAGGED_POLICIES);
    public static final ImplementationConstants MAX_AC_CAPABILITIES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 8, _N.MAX_AC_CAPABILITIES);
    public static final ImplementationConstants MAX_ACT_DATA = new ImplementationConstants(MAX_CAP_DATA.toInt() / 12, _N.MAX_ACT_DATA);

    public ImplementationConstants() {
        super(0, _ValueMap);
    }

    public ImplementationConstants(int value) {
        super(value, _ValueMap);
    }

    public static ImplementationConstants fromInt(int value) {
        return TpmEnum.fromInt(value, _ValueMap, ImplementationConstants.class);
    }

    public static ImplementationConstants fromTpm(byte[] buf) {
        return TpmEnum.fromTpm(buf, _ValueMap, ImplementationConstants.class);
    }

    public static ImplementationConstants fromTpm(TpmBuffer buf) {
        return TpmEnum.fromTpm(buf, _ValueMap, ImplementationConstants.class);
    }

    public _N asEnum() {
        return (_N)this.NameAsEnum;
    }

    public static Collection<ImplementationConstants> values() {
        return _ValueMap.values();
    }

    private ImplementationConstants(int value, _N nameAsEnum) {
        super(value, nameAsEnum, _ValueMap);
    }

    private ImplementationConstants(int value, _N nameAsEnum, boolean noConvFromInt) {
        super(value, nameAsEnum, null);
    }

    @Override
    protected int wireSize() {
        return 4;
    }

    public static enum _N {
        Ossl,
        Ltc,
        Msbn,
        Symcrypt,
        HASH_COUNT,
        MAX_SYM_KEY_BITS,
        MAX_SYM_KEY_BYTES,
        MAX_SYM_BLOCK_SIZE,
        MAX_CAP_CC,
        MAX_RSA_KEY_BYTES,
        MAX_AES_KEY_BYTES,
        MAX_ECC_KEY_BYTES,
        LABEL_MAX_BUFFER,
        _TPM_CAP_SIZE,
        MAX_CAP_DATA,
        MAX_CAP_ALGS,
        MAX_CAP_HANDLES,
        MAX_TPM_PROPERTIES,
        MAX_PCR_PROPERTIES,
        MAX_ECC_CURVES,
        MAX_TAGGED_POLICIES,
        MAX_AC_CAPABILITIES,
        MAX_ACT_DATA;

    }
}

